/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.interpreter.Notation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Notations {
    public static final Notation SINGLE_QUOTED = Notation.notation((String)"'");
    public static final Notation DOUBLE_QUOTED = Notation.notation((String)"\"");
    public static final Notation OPENING_BRACKET = Notation.notation((String)"[");
    public static final Notation CLOSING_BRACKET = Notation.notation((String)"]");
    public static final Notation OPENING_PARENTHESES = Notation.notation((String)"(");
    public static final Notation CLOSING_PARENTHESES = Notation.notation((String)")");
    public static final Notation SCHEMA_AND = Notation.notation((String)"/");
    public static final Notation OPEN_REGEX = Notation.notation((String)"/");
    public static final Notation CLOSE_REGEX = Notation.notation((String)"/");
    public static final Notation OPENING_BRACES = Notation.notation((String)"{");
    public static final Notation CLOSING_BRACES = Notation.notation((String)"}");
    public static final Notation COMMA = Notation.notation((String)",");
    public static final Notation COLUMN_SPLITTER = Notation.notation((String)"|");
    public static final Notation MATRIX_COLUMN_SPLITTER = Notation.notation((String)"^");
    public static final Notation SEQUENCE_AZ = Notation.notation((String)"+");
    public static final Notation SEQUENCE_ZA = Notation.notation((String)"-");
    public static final Notation SEQUENCE_AZ_2 = Notation.notation((String)"\uffea");
    public static final Notation SEQUENCE_ZA_2 = Notation.notation((String)"\uffec");
    public static final Notation TRANSPOSE_MARK = Notation.notation((String)">>");
    public static final Notation LINE_COMMENT1 = Notation.notation((String)"#");
    public static final Notation LINE_COMMENT2 = Notation.notation((String)"//");
    public static final Notation LIST_MAPPING = Notation.notation((String)"[]");
    public static final Notation OPENING_GROUP = Notation.notation((String)"<<");
    public static final Notation CLOSING_GROUP = Notation.notation((String)">>");
    public static final Notation EMPTY = Notation.notation((String)"");
    public static final List<Notation> LINE_COMMENTS = Arrays.asList(LINE_COMMENT1, LINE_COMMENT2);

    public static class Operators {
        public static final Notation WILDCARD = Notation.notation((String)"*");
        public static final Notation ROW_WILDCARD = Notation.notation((String)"***");
        public static final Notation ELEMENT_ELLIPSIS = Notation.notation((String)"...");
        public static final Notation AND = Notation.notation((String)"&&");
        public static final Notation OR = Notation.notation((String)"||");
        public static final Notation COMMA = Notation.notation((String)",");
        public static final Notation GREATER_OR_EQUAL = Notation.notation((String)">=");
        public static final Notation LESS_OR_EQUAL = Notation.notation((String)"<=");
        public static final Notation GREATER = Notation.notation((String)">");
        public static final Notation LESS = Notation.notation((String)"<");
        public static final Notation PLUS = Notation.notation((String)"+");
        public static final Notation SUBTRACTION = Notation.notation((String)"-");
        public static final Notation MULTIPLICATION = Notation.notation((String)"*");
        public static final Notation DIVISION = Notation.notation((String)"/");
        public static final Notation NOT_EQUAL = Notation.notation((String)"!=");
        public static final Notation MINUS = Notation.notation((String)"-");
        public static final Notation NOT = Notation.notation((String)"!");
        public static final Notation MATCHER = Notation.notation((String)":");
        public static final Notation EQUAL = Notation.notation((String)"=");
        public static final Notation DOT = Notation.notation((String)".");
        public static final Notation SLASH = Notation.notation((String)"/");
        public static final Notation META = Notation.notation((String)"::");
        public static final Notation IS = Keywords.IS;
        public static final Notation WHICH = Keywords.WHICH;
    }

    public static class Keywords {
        public static final Notation WHICH = Notation.notation((String)"which");
        public static final Notation IS = Notation.notation((String)"is");
        public static final Notation TRUE = Notation.notation((String)"true");
        public static final Notation FALSE = Notation.notation((String)"false");
        public static final Notation NULL = Notation.notation((String)"null");
        public static final Notation AND = Notation.notation((String)"and");
        public static final Notation OR = Notation.notation((String)"or");
        public static final Set<Notation> ALL = new HashSet<Notation>(Arrays.asList(WHICH, IS, TRUE, FALSE, NULL, AND, OR));
        public static final Set<String> ALL_STRING = ALL.stream().map(Notation::getLabel).collect(Collectors.toSet());
    }
}

