/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DALFactory;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.Classes;
import java.util.List;
import java.util.stream.Collectors;

public class DAL {
    private final Compiler compiler = new Compiler();
    private final RuntimeContextBuilder runtimeContextBuilder = new RuntimeContextBuilder();
    private static final ThreadLocal<DAL> instance = new ThreadLocal();

    public static synchronized DAL getInstance() {
        if (instance.get() == null) {
            instance.set(DALFactory.create());
        }
        return instance.get();
    }

    public RuntimeContextBuilder getRuntimeContextBuilder() {
        return this.runtimeContextBuilder;
    }

    public <T> List<T> evaluateAll(Object input, String expressions) {
        RuntimeContextBuilder.DALRuntimeContext runtimeContext = this.runtimeContextBuilder.build(input);
        return this.compiler.compile(new SourceCode(expressions, Notations.LINE_COMMENTS), runtimeContext).stream().map(node -> node.evaluate(runtimeContext)).collect(Collectors.toList());
    }

    public <T> T evaluate(Object input, String expression) {
        RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2 = this.runtimeContextBuilder.build(input);
        List<DALNode> nodes = this.compiler.compile(new SourceCode(expression, Notations.LINE_COMMENTS), DALRuntimeContext2);
        if (nodes.size() > 1) {
            throw new SyntaxException("more than one expression", nodes.get(1).getPositionBegin());
        }
        return (T)nodes.get(0).evaluate(DALRuntimeContext2);
    }

    public DAL extend() {
        Classes.subTypesOf(Extension.class, (String)"com.github.leeonky.dal.extensions").forEach(c -> ((Extension)Classes.newInstance((Class)c, (Object[])new Object[0])).extend(this));
        return this;
    }
}

