/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ObjectScopeNode;
import com.github.leeonky.dal.ast.node.PropertyThis;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class DALExpression
extends DALNode
implements Expression<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator>,
ExecutableNode {
    private final DALNode left;
    private final DALOperator operator;
    private final DALNode right;

    public DALExpression(DALNode left, DALOperator operator, DALNode right) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        this.setPositionBegin(operator.getPosition());
    }

    public DALNode getLeftOperand() {
        return this.left;
    }

    public DALNode getRightOperand() {
        return this.right;
    }

    public DALOperator getOperator() {
        return this.operator;
    }

    @Override
    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            return this.logFalseResultAsNeeded(this.operator.calculateData(this.left, this.right, context));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), this.operator.getPosition());
        }
    }

    private Data logFalseResultAsNeeded(Data result) {
        if (this.operator.isNeedInspect() && result.getInstance() instanceof Boolean && !((Boolean)result.getInstance()).booleanValue()) {
            System.err.println("Warning: Expression `" + this.inspect() + "` got false.");
        }
        return result;
    }

    @Override
    public String inspect() {
        return this.operator.inspect(this.left == null ? null : this.left.inspect(), this.right.inspect());
    }

    @Override
    public Object getRootSymbolName() {
        return this.left instanceof InputNode || this.isRootPropertyThis() ? this.right.getRootSymbolName() : this.left.getRootSymbolName();
    }

    private boolean isRootPropertyThis() {
        return this.left instanceof DALExpression && ((DALExpression)this.left).getRightOperand() instanceof PropertyThis;
    }

    public int getOperandPosition() {
        return this.right.getPositionBegin();
    }

    @Override
    public List<Object> propertyChain() {
        return new ArrayList<Object>(){
            {
                this.addAll(DALExpression.this.left.propertyChain());
                this.addAll(DALExpression.this.right.propertyChain());
            }
        };
    }

    @Override
    public Stream<Object> collectFields(Data data) {
        if (((DALExpression)this.getLeftOperand()).getRightOperand() instanceof PropertyThis && this.getRightOperand() instanceof ObjectScopeNode) {
            return this.getRightOperand().collectFields(data);
        }
        return super.collectFields(data);
    }

    @Override
    public Data getValue(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.newBlockScope(data, () -> this.evaluateData(context));
    }
}

