/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.ConstNode;
import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.table.DefaultIndexRowType;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.node.table.SpecifyIndexRowType;
import com.github.leeonky.dal.ast.node.table.SpecifyPropertyRowType;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.NodeBase;
import com.github.leeonky.interpreter.Operator;
import com.github.leeonky.interpreter.OperatorParser;
import com.github.leeonky.util.function.Extension;
import java.util.Optional;
import java.util.function.Supplier;

public class TableRowPrefixNode
extends DALNode {
    private static final RowType DEFAULT_INDEX = new DefaultIndexRowType();
    private static final RowType SPECIFY_INDEX = new SpecifyIndexRowType();
    private static final RowType SPECIFY_PROPERTY = new SpecifyPropertyRowType();
    private final Optional<DALNode> indexOrProperty;
    private final Optional<Clause<DALNode>> rowSchema;
    private final Optional<DALOperator> rowOperator;

    public TableRowPrefixNode(Optional<DALNode> indexOrProperty, Optional<Clause<DALNode>> rowSchema, Optional<DALOperator> rowOperator) {
        this.rowSchema = rowSchema;
        this.rowOperator = rowOperator;
        this.indexOrProperty = indexOrProperty;
    }

    @Override
    public String inspect() {
        String indexAndSchema = (this.indexOrProperty.map(DALNode::inspect).orElse("") + " " + this.rowSchema.map(clause -> ((DALNode)clause.expression(null)).inspect()).orElse("")).trim();
        return this.rowOperator.map(dalOperator -> dalOperator.inspect(indexAndSchema, "").trim()).orElse(indexAndSchema);
    }

    public DALExpression makeExpressionWithOptionalIndexAndSchema(RowType rowType, DALNode input, DALOperator defaultOperator, DALNode expectedRow) {
        DALNode rowAccessor = rowType.constructAccessingRowNode(input, this.indexOrProperty);
        return new DALExpression(this.rowSchema.map(clause -> (DALNode)clause.expression((Node)rowAccessor)).orElse(rowAccessor), this.rowOperator.orElse(defaultOperator), expectedRow);
    }

    public OperatorParser<DALNode, DALOperator, DALProcedure> operator() {
        return procedure -> this.rowOperator;
    }

    public RowType resolveRowType() {
        return this.indexOrProperty.map(dalNode -> {
            if (dalNode instanceof ConstNode) {
                return SPECIFY_INDEX;
            }
            if (dalNode instanceof DALExpression) {
                return SPECIFY_PROPERTY;
            }
            return DEFAULT_INDEX;
        }).orElse(DEFAULT_INDEX);
    }

    public Optional<Integer> position() {
        return Extension.getFirstPresent((Supplier[])new Supplier[]{() -> this.indexOrProperty.map(NodeBase::getPositionBegin), () -> this.rowSchema.map(c -> ((DALExpression)c.expression((Node)InputNode.INPUT_NODE)).getOperator().getPosition()), () -> this.rowOperator.map(Operator::getPosition)});
    }
}

