/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.NodeType;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectScopeNode
extends DALNode {
    private final List<DALNode> verificationExpressions = new ArrayList<DALNode>();
    private final boolean isObjectWildcard;

    public ObjectScopeNode(List<DALNode> expressions) {
        this.verificationExpressions.addAll(expressions);
        this.isObjectWildcard = false;
    }

    public ObjectScopeNode(DALNode ignore) {
        this.isObjectWildcard = true;
    }

    @Override
    public String inspect() {
        return String.format("{%s}", this.isObjectWildcard ? "..." : this.verificationExpressions.stream().map(DALNode::inspect).collect(Collectors.joining(", ")));
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return NodeType.OBJECT_SCOPE;
    }

    @Override
    public Data verify(DALNode actualNode, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        Data data = this.evaluateActualAndCheckNull(actualNode, context);
        data.execute(() -> {
            this.verificationExpressions.forEach(expression -> expression.evaluate(context));
            AssertionFailure.assertUnexpectedFields(this.collectUnexpectedFields(data, context), actualNode.inspect(), operator.getPosition());
            return true;
        });
        Data placeholder = this.evaluateData(context);
        return this.checkerVerify(context.fetchEqualsChecker(placeholder, data), placeholder, data, context);
    }

    private Data evaluateActualAndCheckNull(DALNode actualNode, RuntimeContextBuilder.DALRuntimeContext context) {
        Data data = actualNode.evaluateData(context);
        if (data.isNullWithPosition(actualNode.getOperandPosition())) {
            throw new AssertionFailure("The input value is null", this.getOperandPosition());
        }
        return data;
    }

    @Override
    public Data verify(DALNode actualNode, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        if (this.verificationExpressions.isEmpty() && !this.isObjectWildcard) {
            throw new SyntaxException("Should use `{...}` to verify any non null object", this.getPositionBegin());
        }
        Data data = this.evaluateActualAndCheckNull(actualNode, context);
        data.execute(() -> {
            this.verificationExpressions.forEach(expression -> expression.evaluate(context));
            return data;
        });
        Data placeholder = this.evaluateData(context);
        return this.checkerVerify(context.fetchMatchingChecker(placeholder, data), placeholder, data, context);
    }

    private Set<Object> collectUnexpectedFields(final Data data, final RuntimeContextBuilder.DALRuntimeContext context) {
        return new LinkedHashSet<Object>(data.fieldNames()){
            {
                super(x0);
                Stream.concat(ObjectScopeNode.this.collectFields(data), context.collectPartialProperties(data).stream()).map(obj -> ObjectScopeNode.this.convertFiled(data, obj)).forEach(this::remove);
            }
        };
    }

    private Object convertFiled(Data data, Object obj) {
        return data.instance() instanceof CurryingMethod ? ((CurryingMethod)data.instance()).convertToArgType(obj) : obj;
    }

    @Override
    public Stream<Object> collectFields(Data data) {
        return this.verificationExpressions.stream().flatMap(expression -> expression.collectFields(data));
    }
}

