/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.DelegateNode;
import com.github.leeonky.dal.ast.node.table.Body;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class TableNode
extends DALNode {
    private final ColumnHeaderRow columnHeaderRow;
    private final Body body;

    public TableNode(ColumnHeaderRow columnHeaderRow, Body body) {
        this.columnHeaderRow = columnHeaderRow;
        this.body = body.checkFormat(this.columnHeaderRow);
        this.setPositionBegin(columnHeaderRow.getPositionBegin());
    }

    @Override
    public Data verify(DALNode actualNode, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        DelegateNode node = new DelegateNode(actualNode);
        Data actual = node.evaluateData(context);
        try {
            return this.convertToVerificationNode(actual, operator, context).verify((DALNode)node, operator, context);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    @Override
    public Data verify(DALNode actualNode, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        DelegateNode node = new DelegateNode(actualNode);
        Data actual = node.evaluateData(context);
        try {
            return this.convertToVerificationNode(actual, operator, context).verify((DALNode)node, operator, context);
        }
        catch (RowAssertionFailure rowAssertionFailure) {
            throw rowAssertionFailure.linePositionException(this);
        }
    }

    public DALNode convertToVerificationNode(Data actual, DALOperator operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return (DALNode)this.body.convertToVerificationNode(actual, operator, this.columnHeaderRow.collectComparator(context)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return (this.columnHeaderRow.inspect() + this.body.inspect()).trim();
    }

    public static String printLine(List<? extends DALNode> nodes) {
        return nodes.stream().map(DALNode::inspect).collect(Collectors.joining(" | ", "| ", " |"));
    }

    public Row fetchDataRowSkipEllipsis(int indexSkipEllipsis) {
        return this.body.dataRowSkipEllipsis(indexSkipEllipsis);
    }
}

