/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ListEllipsisNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.WildcardNode;
import com.github.leeonky.dal.ast.node.table.ColumnHeader;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.EmptyCell;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.ast.node.table.TransposedRowHeaderRow;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TransposedRow
extends DALNode {
    private final ColumnHeader columnHeader;
    private final List<Clause<DALNode>> cellClauses;

    public TransposedRow(DALNode header, List<Clause<DALNode>> clauses) {
        this.cellClauses = clauses;
        this.columnHeader = (ColumnHeader)header;
        this.setPositionBegin(header.getPositionBegin());
    }

    @Override
    public String inspect() {
        return TableNode.printLine((List<? extends DALNode>)new ArrayList<DALNode>(){
            {
                this.add(TransposedRow.this.columnHeader);
                this.addAll(TransposedRow.this.cellClauses.stream().map(clause -> (DALNode)clause.expression((Node)InputNode.INPUT_NODE)).collect(Collectors.toList()));
            }
        });
    }

    public List<Row> transpose(final TransposedRowHeaderRow transposedRowHeaderRow) {
        return new ArrayList<Row>(){
            {
                for (int i = 0; i < TransposedRow.this.cellClauses.size(); ++i) {
                    this.add(new Row((DALNode)transposedRowHeaderRow.getRowHeader(i), Collections.singletonList(TransposedRow.this.cellClauses.get(i)), new ColumnHeaderRow(Collections.singletonList(TransposedRow.this.columnHeader))));
                }
            }
        };
    }

    public ColumnHeader getHeader() {
        return this.columnHeader;
    }

    public int cellCount() {
        return this.cellClauses.size();
    }

    public void replaceEmptyCell(TransposedRow firstRow) {
        for (int i = 0; i < firstRow.cellClauses.size(); ++i) {
            DALNode row = (DALNode)firstRow.cellClauses.get(i).expression((Node)InputNode.INPUT_NODE);
            if (!(row instanceof WildcardNode) && !(row instanceof ListEllipsisNode)) continue;
            this.cellClauses.set(i, (Clause<DALNode>)((Clause)node -> new EmptyCell()));
        }
    }
}

