/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SourceCode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Supplier;

public class DALProcedure
extends Procedure<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator> {
    private final LinkedList<Boolean> enableAndComma = new LinkedList<Boolean>(Collections.singleton(true));
    private boolean enableSlashProperty = false;
    private boolean enableRelaxProperty = false;
    private boolean enableNumberProperty = false;

    public DALProcedure(SourceCode sourceCode, RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
        super(sourceCode, (RuntimeContext)runtimeContext);
    }

    public static NodeParser<DALNode, DALProcedure> disableCommaAnd(NodeParser<DALNode, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(false, () -> nodeParser.parse(procedure));
    }

    public static NodeParser<DALNode, DALProcedure> enableCommaAnd(NodeParser<DALNode, DALProcedure> nodeParser) {
        return procedure -> procedure.commaAnd(true, () -> nodeParser.parse(procedure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> commaAnd(boolean b, Supplier<Optional<T>> nodeFactory) {
        this.enableAndComma.push(b);
        try {
            Optional<T> optional = nodeFactory.get();
            return optional;
        }
        finally {
            this.enableAndComma.pop();
        }
    }

    public boolean isEnableCommaAnd() {
        return this.enableAndComma.getFirst();
    }

    public boolean isCodeBeginning() {
        return this.getSourceCode().isBeginning();
    }

    public boolean mayBeUnEqual() {
        return this.getSourceCode().startsWith(Notations.Operators.NOT_EQUAL, new String[0]);
    }

    public boolean mayBeOpeningGroup() {
        return this.getSourceCode().startsWith(Notations.OPENING_GROUP, new String[0]);
    }

    public boolean mayBeElementEllipsis() {
        return this.getSourceCode().startsWith("..");
    }

    public boolean isEnableSlashProperty() {
        return this.enableSlashProperty;
    }

    public boolean mayBeMetaProperty() {
        return this.getSourceCode().startsWith("::");
    }

    public static NodeParser<DALNode, DALProcedure> enableSlashProperty(NodeParser<DALNode, DALProcedure> nodeParser) {
        return procedure -> procedure.enableSlashProperty(() -> nodeParser.parse(procedure));
    }

    public static NodeParser.Mandatory<DALNode, DALProcedure> enableSlashProperty(NodeParser.Mandatory<DALNode, DALProcedure> mandatory) {
        return procedure -> procedure.enableSlashProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableSlashProperty(Supplier<T> supplier) {
        this.enableSlashProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableSlashProperty = false;
        }
    }

    public boolean isEnableRelaxProperty() {
        return this.enableRelaxProperty;
    }

    public static NodeParser.Mandatory<DALNode, DALProcedure> enableNumberProperty(NodeParser.Mandatory<DALNode, DALProcedure> mandatory) {
        return procedure -> procedure.enableNumberProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableNumberProperty(Supplier<T> supplier) {
        this.enableNumberProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableNumberProperty = false;
        }
    }

    public boolean isEnableNumberProperty() {
        return this.enableNumberProperty;
    }

    public static NodeParser<DALNode, DALProcedure> enableRelaxProperty(NodeParser<DALNode, DALProcedure> nodeParser) {
        return procedure -> procedure.enableRelaxProperty(() -> nodeParser.parse(procedure));
    }

    public static NodeParser.Mandatory<DALNode, DALProcedure> enableRelaxProperty(NodeParser.Mandatory<DALNode, DALProcedure> mandatory) {
        return procedure -> procedure.enableRelaxProperty(() -> (DALNode)((Object)((Object)((Object)mandatory.parse(procedure)))));
    }

    private <T> T enableRelaxProperty(Supplier<T> supplier) {
        this.enableRelaxProperty = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enableRelaxProperty = false;
        }
    }

    @Deprecated
    public DALNode createExpression(DALNode left, DALOperator operator, DALNode right) {
        return DALExpression.expression(left, operator, right);
    }
}

