/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.IllegalOperationException;
import com.github.leeonky.dal.runtime.InfiniteCollectionException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.Classes;
import com.github.leeonky.util.CollectionHelper;
import com.github.leeonky.util.NumberType;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;

public class Calculator {
    private static final NumberType numberType = new NumberType();

    public static int compare(Object v1, Object v2, RuntimeContextBuilder.DALRuntimeContext context) {
        if (v1 == null || v2 == null) {
            throw new IllegalOperationException(String.format("Can not compare [%s] and [%s]", v1, v2));
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            return context.getNumberType().compare((Number)v1, (Number)v2);
        }
        if (v1 instanceof String && v2 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        throw new IllegalOperationException(String.format("Can not compare [%s: %s] and [%s: %s]", Classes.getClassName((Object)v1), v1, Classes.getClassName((Object)v2), v2));
    }

    public static boolean equals(Data v1, Data v2) {
        if (v2.isNull()) {
            return v1.isNull();
        }
        if (v2.isList()) {
            return CollectionHelper.equals((Object)v1.instance(), (Object)v2.instance());
        }
        return Objects.equals(v1.instance(), v2.instance());
    }

    public static Object plus(Object v1, Object v2, RuntimeContextBuilder.DALRuntimeContext context) {
        if (v1 instanceof Number && v2 instanceof Number) {
            return context.getNumberType().plus((Number)v1, (Number)v2);
        }
        if (v1 instanceof String) {
            return v1.toString() + v2;
        }
        if (v2 instanceof String) {
            return v1 + v2.toString();
        }
        throw new IllegalOperationException(String.format("Can not plus '%s' and '%s'", Classes.getClassName((Object)v1), Classes.getClassName((Object)v2)));
    }

    public static Object subtract(Object v1, Object v2, RuntimeContextBuilder.DALRuntimeContext context) {
        Calculator.requireNumber(v1, v2);
        return context.getNumberType().subtract((Number)v1, (Number)v2);
    }

    public static Object multiply(Object v1, Object v2, RuntimeContextBuilder.DALRuntimeContext context) {
        Calculator.requireNumber(v1, v2);
        return context.getNumberType().multiply((Number)v1, (Number)v2);
    }

    public static Object divide(Object v1, Object v2, RuntimeContextBuilder.DALRuntimeContext context) {
        Calculator.requireNumber(v1, v2);
        return context.getNumberType().divide((Number)v1, (Number)v2);
    }

    private static void requireNumber(Object v1, Object v2) {
        if (!(v1 instanceof Number) || !(v2 instanceof Number)) {
            throw new IllegalOperationException(String.format("Operands should be number but '%s' and '%s'", Classes.getClassName((Object)v1), Classes.getClassName((Object)v2)));
        }
    }

    public static Data and(Supplier<Data> s1, Supplier<Data> s2) {
        Data v1 = s1.get();
        return Calculator.isTrue(v1) ? s2.get() : v1;
    }

    private static boolean isTrue(Data value) {
        if (value.instance() instanceof Boolean) {
            return (Boolean)value.instance();
        }
        if (value.instance() instanceof Number) {
            return numberType.compare((Number)0, (Number)value.instance()) != 0;
        }
        return !value.isNull();
    }

    public static Data or(Supplier<Data> s1, Supplier<Data> s2) {
        Data v1 = s1.get();
        return Calculator.isTrue(v1) ? v1 : s2.get();
    }

    public static Object not(Object v) {
        Calculator.requireBooleanType(v, "Operand");
        return (Boolean)v == false;
    }

    public static void requireBooleanType(Object v, String operand) {
        if (!(v instanceof Boolean)) {
            throw new IllegalOperationException(operand + " should be boolean but '" + Classes.getClassName((Object)v) + "'");
        }
    }

    public static Data negate(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        Object value = data.instance();
        if (value instanceof Number) {
            return context.wrap(context.getNumberType().negate((Number)value));
        }
        if (data.isList()) {
            return Calculator.sortList(data, Comparator.reverseOrder());
        }
        throw new IllegalOperationException(String.format("Operand should be number but '%s'", Classes.getClassName((Object)value)));
    }

    private static Data sortList(Data data, Comparator<?> comparator) {
        try {
            return data.list().sort(Comparator.comparing(Data::instance, comparator)).wrap();
        }
        catch (InfiniteCollectionException e) {
            throw new IllegalOperationException("Can not sort infinite collection");
        }
    }

    public static Data positive(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        Object value = data.instance();
        if (value instanceof Number) {
            return context.wrap(value);
        }
        if (data.isList()) {
            return Calculator.sortList(data, Comparator.naturalOrder());
        }
        throw new IllegalOperationException(String.format("Operands should be List but '%s'", Classes.getClassName((Object)value)));
    }

    public static boolean less(Object left, Object right, RuntimeContextBuilder.DALRuntimeContext context) {
        return Calculator.compare(left, right, context) < 0;
    }

    public static boolean greaterOrEqual(Object left, Object right, RuntimeContextBuilder.DALRuntimeContext context) {
        return Calculator.compare(left, right, context) >= 0;
    }

    public static boolean lessOrEqual(Object left, Object rgiht, RuntimeContextBuilder.DALRuntimeContext context) {
        return Calculator.compare(left, rgiht, context) <= 0;
    }

    public static boolean greater(Object left, Object right, RuntimeContextBuilder.DALRuntimeContext context) {
        return Calculator.compare(left, right, context) > 0;
    }

    public static boolean notEqual(Data left, Data right) {
        return !Calculator.equals(left, right);
    }
}

