/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.util.Classes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ClassKeyMap<T> {
    private final LinkedHashMap<Class<?>, T> map = new LinkedHashMap();

    public Optional<T> tryGetData(Object object) {
        if (object == null) {
            return Optional.empty();
        }
        T data = this.map.get(object.getClass());
        if (data != null) {
            return Optional.of(data);
        }
        return this.map.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(object)).sorted(Map.Entry.comparingByKey(Classes::compareByExtends)).map(Map.Entry::getValue).findFirst();
    }

    public boolean containsType(Object object) {
        return this.tryGetData(object).isPresent();
    }

    public T getData(Object instance) {
        return this.tryGetData(instance).orElseThrow(IllegalArgumentException::new);
    }

    public T put(Class<?> type, T value) {
        return this.map.put(type, value);
    }

    public T get(Class<?> type, Supplier<T> defaultFactory) {
        T result = this.map.get(type);
        if (result == null) {
            result = defaultFactory.get();
            this.map.put(type, result);
        }
        return result;
    }
}

