/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.IndexedElement;
import com.github.leeonky.dal.runtime.DALCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionDALCollection<E>
extends DALCollection<E> {
    private final List<E> list;

    public CollectionDALCollection(Collection<E> collection) {
        this.list = new ArrayList<E>(collection);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    protected E getByPosition(int position) {
        return this.list.get(position);
    }

    @Override
    public Iterator<IndexedElement<E>> iterator() {
        return new Iterator<IndexedElement<E>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CollectionDALCollection.this.list.size();
            }

            @Override
            public IndexedElement<E> next() {
                return new IndexedElement(this.index + CollectionDALCollection.this.firstIndex(), CollectionDALCollection.this.list.get(this.index++));
            }
        };
    }

    @Override
    public List<E> collect() {
        return this.list;
    }
}

