/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.checker;

import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.StringWithPosition;

public class CheckingContext {
    private final Data originalExpected;
    private final Data originalActual;
    private final Data expected;
    private final Data actual;
    private final int position;

    public Data getOriginalActual() {
        return this.originalActual;
    }

    public Data getOriginalExpected() {
        return this.originalExpected;
    }

    public CheckingContext(Data originalExpected, Data originalActual, Data expected, Data actual, int position) {
        this.originalExpected = originalExpected;
        this.originalActual = originalActual;
        this.expected = expected;
        this.actual = actual;
        this.position = position;
    }

    public boolean objectNotEquals() {
        return !Calculator.equals(this.actual, this.expected);
    }

    public String messageEqualTo() {
        return this.verificationMessage("Expected to be equal to: ", "");
    }

    public String messageMatch() {
        return this.verificationMessage("Expected to match: ", this.actual.instance() == this.originalActual.instance() ? "" : " converted from: " + this.originalActual.dumpAll());
    }

    public String verificationMessage(String prefix, String actualPostfix) {
        String actual = this.actual.dumpAll() + actualPostfix;
        String expected = this.expected.dumpAll();
        int position = TextUtil.differentPosition(expected, actual);
        return new StringWithPosition(actual).position(position).result(new StringWithPosition(expected).position(position).result(prefix) + "\nActual: ");
    }

    public String cannotCompare() {
        return String.format("Cannot compare between %s\nand %s", this.actual.dumpAll(), this.expected.dumpAll());
    }

    public int getPosition() {
        return this.position;
    }

    public Data getExpected() {
        return this.expected;
    }

    public Data getActual() {
        return this.actual;
    }
}

