/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.IndexedElement;
import com.github.leeonky.dal.runtime.InfiniteCollectionException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class DALCollection<E>
implements Iterable<IndexedElement<E>> {
    public abstract int size();

    public E getByIndex(int index) {
        try {
            if (index < 0) {
                return this.requireLimitedCollection("Not support negative index in infinite collection").getByPosition(this.size() + index);
            }
            return this.getByPosition(index - this.firstIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds (%d), first index is: %d", index, this.firstIndex()));
        }
    }

    protected int firstIndex() {
        return 0;
    }

    public DALCollection<E> requireLimitedCollection(String message) {
        if (this.infinite()) {
            throw new InfiniteCollectionException(message);
        }
        return this;
    }

    protected abstract E getByPosition(int var1);

    public List<E> collect() {
        return this.requireLimitedCollection("Not supported for infinite collection").stream().map(IndexedElement::value).collect(Collectors.toList());
    }

    public Stream<E> values() {
        return this.stream().map(IndexedElement::value);
    }

    public Stream<Integer> indexes() {
        return this.stream().map(IndexedElement::index);
    }

    public <R> DALCollection<R> map(final IndexedElement.Mapper<? super E, ? extends R> mapper) {
        return new DALCollection<R>(){

            @Override
            public int size() {
                return DALCollection.this.size();
            }

            @Override
            protected int firstIndex() {
                return DALCollection.this.firstIndex();
            }

            @Override
            protected R getByPosition(int position) {
                return mapper.apply(position + this.firstIndex(), DALCollection.this.getByPosition(position));
            }

            @Override
            public Iterator<IndexedElement<R>> iterator() {
                return new Iterator<IndexedElement<R>>(){
                    final Iterator<IndexedElement<E>> iterator;
                    {
                        this.iterator = DALCollection.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IndexedElement<R> next() {
                        return this.iterator.next().map(mapper);
                    }
                };
            }

            @Override
            public boolean infinite() {
                return DALCollection.this.infinite();
            }
        };
    }

    public Stream<IndexedElement<E>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean infinite() {
        return false;
    }

    public static class Decorated<E>
    extends DALCollection<E> {
        private final DALCollection<E> origin;

        public Decorated(DALCollection<E> origin) {
            this.origin = origin;
        }

        @Override
        public int size() {
            return this.origin.size();
        }

        @Override
        protected E getByPosition(int position) {
            return this.origin.getByPosition(position);
        }

        @Override
        public Iterator<IndexedElement<E>> iterator() {
            return this.origin.iterator();
        }

        @Override
        protected int firstIndex() {
            return this.origin.firstIndex();
        }

        @Override
        public List<E> collect() {
            return this.origin.collect();
        }

        @Override
        public boolean infinite() {
            return this.origin.infinite();
        }

        @Override
        public Stream<E> values() {
            return this.origin.values();
        }

        @Override
        public Stream<Integer> indexes() {
            return this.origin.indexes();
        }

        @Override
        public DALCollection<E> requireLimitedCollection(String message) {
            this.origin.requireLimitedCollection(message);
            return this;
        }
    }
}

