/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeData;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.util.InvocationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MetaData
extends RuntimeData {
    private Throwable error;
    private RuntimeException originalException;
    private final Object name;
    protected Data data;
    private final List<Class<?>> callTypes = new ArrayList();

    public MetaData(DALNode inputNode, DALNode operandNode, RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
        super(null, inputNode, operandNode, runtimeContext, null);
        this.name = operandNode.getRootSymbolName();
        this.setData(() -> this.inputNode().evaluateData(this.runtimeContext()));
    }

    private MetaData(DALNode inputNode, DALNode operandNode, RuntimeContextBuilder.DALRuntimeContext runtimeContext, Data data, Throwable error, RuntimeException originalException, String name) {
        super(null, inputNode, operandNode, runtimeContext, null);
        this.name = name;
        this.error = error;
        this.originalException = originalException;
        this.data = data;
    }

    private void setData(Supplier<Data> supplier) {
        try {
            this.data = supplier.get();
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof InvocationException)) {
                throw e;
            }
            this.originalException = e;
            this.error = e.getCause().getCause();
            this.data = this.runtimeContext.wrap(null);
        }
    }

    public Throwable catchError() {
        Throwable throwable = this.error;
        this.error = null;
        return throwable;
    }

    public Object callSuper() {
        return this.runtimeContext().fetchSuperMetaFunction(this).orElseThrow(this::noSuperError).apply(this);
    }

    public Object callSuper(Supplier<Object> supplier) {
        this.setData(() -> {
            Object newData = supplier.get();
            this.checkType(newData);
            return this.runtimeContext.wrap(newData);
        });
        return this.callSuper();
    }

    public Object callGlobal() {
        return this.runtimeContext().fetchGlobalMetaFunction(this).apply(this);
    }

    public Object callGlobal(Supplier<Object> supplier) {
        this.setData(() -> this.runtimeContext.wrap(supplier.get()));
        return this.callGlobal();
    }

    private MetaData newMeta(String name) {
        return new MetaData(this.inputNode, this.OperandNode, this.runtimeContext, this.data, this.error, this.originalException, name);
    }

    public Object callMeta(String another) {
        MetaData metaData = this.newMeta(another);
        return this.runtimeContext().fetchGlobalMetaFunction(metaData).apply(metaData);
    }

    public Object callMeta(String another, Supplier<Object> supplier) {
        MetaData metaData = this.newMeta(another);
        metaData.setData(() -> this.runtimeContext.wrap(supplier.get()));
        return this.runtimeContext().fetchGlobalMetaFunction(metaData).apply(metaData);
    }

    private void checkType(Object data) {
        Class<?> expect = this.data.instance().getClass();
        Class<?> actual = Objects.requireNonNull(data).getClass();
        if (actual.isAnonymousClass()) {
            actual = actual.getSuperclass();
        }
        if (!actual.equals(expect)) {
            throw new RuntimeException(String.format("Do not allow change data type in callSuper, expect %s but %s", expect.getName(), actual.getName()), this.OperandNode.getPositionBegin());
        }
    }

    private RuntimeException noSuperError() {
        return new RuntimeException(String.format("Local meta property `%s` has no super in type %s", this.OperandNode.getRootSymbolName(), this.callTypes.get(this.callTypes.size() - 1).getName()), this.OperandNode.getPositionBegin());
    }

    public void addCallType(Class<?> callType) {
        this.callTypes.add(callType);
    }

    public boolean calledBy(Class<?> type) {
        return this.callTypes.contains(type);
    }

    public boolean isInstance(Class<?> type) {
        return type.isInstance(this.data.instance());
    }

    public Object name() {
        return this.name;
    }

    @Override
    public Data data() {
        if (this.error != null) {
            throw this.originalException;
        }
        return this.data;
    }
}

