/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.type.FieldAlias;
import com.github.leeonky.dal.type.FieldAliases;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.function.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SchemaType {
    private final BeanClass<?> schema;
    private final Object fromProperty;
    private final SchemaType parent;
    private static final Compiler compiler = new Compiler();

    private SchemaType(BeanClass<?> schema) {
        this(schema, null, null);
    }

    private SchemaType(BeanClass<?> schema, Object fromProperty, SchemaType parent) {
        this.schema = schema;
        this.fromProperty = fromProperty;
        this.parent = parent;
    }

    public static SchemaType create(BeanClass<?> schema) {
        return new SchemaType(schema);
    }

    private String fetchFieldChain(String name) {
        return this.allAliases().stream().filter(fieldAlias -> fieldAlias.alias().equals(name)).map(FieldAlias::field).findFirst().orElse(name);
    }

    private List<FieldAlias> allAliases() {
        return this.collectAlias(this.schema == null ? null : this.schema.getType());
    }

    private List<FieldAlias> collectAlias(Class<?> type) {
        ArrayList<FieldAlias> aliases = new ArrayList<FieldAlias>();
        if (type != null) {
            FieldAliases fieldAliases = type.getAnnotation(FieldAliases.class);
            if (fieldAliases != null) {
                aliases.addAll(Arrays.asList(fieldAliases.value()));
            }
            aliases.addAll(this.collectAlias(type.getSuperclass()));
            for (Class<?> interfaceType : type.getInterfaces()) {
                aliases.addAll(this.collectAlias(interfaceType));
            }
        }
        return aliases;
    }

    public SchemaType access(Object alias) {
        if (this.isIntegerForListIndex(alias)) {
            return this.subSchema(alias);
        }
        String property = this.fetchFieldChain((String)alias);
        if (Objects.equals(property, alias)) {
            return this.subSchema(property);
        }
        List<Object> chain = compiler.toChainNodes(property);
        return chain.stream().skip(1L).reduce(this.access(chain.get(0)), SchemaType::access, Extension.notAllowParallelReduce());
    }

    private SchemaType subSchema(Object property) {
        try {
            if (this.isIntegerForListIndex(property)) {
                return new SchemaType(this.schema.getElementType(), property, this);
            }
            return new SchemaType(this.schema.getPropertyChainReader((String)property).getType(), property, this);
        }
        catch (Exception e) {
            return new SchemaType(null, property, this);
        }
    }

    private boolean isIntegerForListIndex(Object property) {
        return property instanceof Integer || property instanceof Long;
    }

    public List<Object> getPropertyChainBefore(SchemaType schemaOrder) {
        if (schemaOrder == this) {
            return new ArrayList<Object>();
        }
        List<Object> chain = this.parent.getPropertyChainBefore(schemaOrder);
        chain.add(this.fromProperty);
        return chain;
    }

    public SchemaType mappingAccess(final Object property) {
        return new SchemaType(null){

            @Override
            public SchemaType access(Object alias) {
                return new SchemaType(SchemaType.this.access(alias).access(property).schema, alias, this);
            }
        };
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.access(alias).getPropertyChainBefore(this).get(0);
    }
}

