/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.schema;

import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Type;
import com.github.leeonky.dal.format.Value;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.SchemaAssertionFailure;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.Schema;
import com.github.leeonky.dal.type.SubType;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Classes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Actual {
    private final String property;
    private final Data actual;
    private static final Compiler compiler = new Compiler();

    public Actual(String property, Data actual) {
        this.property = property;
        this.actual = actual;
    }

    public static Actual actual(Data data) {
        return new Actual("", data);
    }

    public Actual sub(Object property) {
        return new Actual(this.property + "." + property, this.actual.getValue(property));
    }

    public boolean isNull() {
        return this.actual.isNull();
    }

    public Actual sub(Integer index) {
        return new Actual(this.property + "[" + index + "]", this.actual.getValue(index));
    }

    public Class<Object> polymorphicSchemaType(Class<?> schemaType) {
        return Optional.ofNullable(schemaType.getAnnotation(SubType.class)).map(subType -> {
            Object subTypeProperty = this.actual.getValue(compiler.toChainNodes(subType.property())).instance();
            return Stream.of(subType.types()).filter(t -> t.value().equals(subTypeProperty)).map(SubType.Type::type).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Cannot guess sub type through property type value[%s]", subTypeProperty)));
        }).orElse(schemaType);
    }

    public IllegalStateException invalidGenericType() {
        return new IllegalStateException(String.format("%s should specify generic type", this.property));
    }

    public boolean convertAble(BeanClass<?> type, String inspect) {
        if (this.isNull()) {
            return Verification.errorLog("Can not convert null field `%s` to %s, use @AllowNull to verify nullable field", this.property, inspect);
        }
        try {
            this.actual.convert(type.getType());
            return true;
        }
        catch (Exception ignore) {
            return Verification.errorLog("Can not convert field `%s` (%s: %s) to %s", this.property, Classes.getClassName((Object)this.actual.instance()), this.actual.instance(), inspect);
        }
    }

    public boolean verifyValue(Value<Object> value, BeanClass<?> type) {
        return value.verify(value.convertAs(this.actual, type)) || Verification.errorLog(value.errorMessage(this.property, this.actual.instance()), new Object[0]);
    }

    public Stream<Object> fieldNames() {
        return this.actual.fieldNames().stream();
    }

    public Stream<Actual> subElements() {
        return this.actual.list().wraps().stream().map(data -> new Actual(this.property + "[" + data.index() + "]", (Data)data.value()));
    }

    public boolean verifyFormatter(Formatter<Object, Object> formatter) {
        return formatter.isValid(this.actual.instance()) || Verification.errorLog("Expected field `%s` to be formatter `%s`\nActual: %s", this.property, formatter.getFormatterName(), this.actual.dumpAll());
    }

    boolean verifySize(Function<Actual, Stream<?>> actualStream, int expectSize) {
        return actualStream.apply(this).count() == (long)expectSize || Verification.errorLog("Expected field `%s` to be size <%d>, but was size <%d>", this.property, expectSize, actualStream.apply(this).count());
    }

    boolean moreExpectSize(int size) {
        return Verification.errorLog("Collection Field `%s` size was only <%d>, expected too more", this.property, size);
    }

    public boolean lessExpectSize(int size) {
        return Verification.errorLog("Expected collection field `%s` to be size <%d>, but too many elements", this.property, size);
    }

    boolean verifyType(Type<Object> expect) {
        return expect.verify(this.actual.instance()) || Verification.errorLog(expect.errorMessage(this.property, this.actual.instance()), new Object[0]);
    }

    boolean inInstanceOf(BeanClass<?> type) {
        return type.isInstance(this.actual.instance()) || Verification.errorLog(String.format("Expected field `%s` to be %s\nActual: %s", this.property, type.getName(), this.actual.dumpAll()), new Object[0]);
    }

    public boolean equalsExpect(Object expect, RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
        return Objects.equals(expect, this.actual.instance()) || Verification.errorLog(String.format("Expected field `%s` to be %s\nActual: %s", this.property, runtimeContext.wrap(expect).dumpAll(), this.actual.dumpAll()), new Object[0]);
    }

    public void verifySchema(Schema expect) {
        try {
            expect.verify(this.actual);
        }
        catch (SchemaAssertionFailure schemaAssertionFailure) {
            Verification.errorLog(schemaAssertionFailure.getMessage(), new Object[0]);
        }
    }
}

