/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ListEllipsisNode;
import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.ast.node.SymbolNode;
import com.github.leeonky.dal.ast.opt.Factory;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.ListMappingElementAccessException;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.Zipped;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ListScopeNode
extends DALNode {
    private List<DALNode> verificationExpressions;
    private List<DALNode> inputExpressions;
    private List<Clause<DALNode>> inputClauses;
    private final Type type;
    private final Style style;
    private final Comparator<Data> comparator;

    public ListScopeNode(List<Clause<DALNode>> clauses, Comparator<Data> comparator, Style style) {
        this.type = this.guessType(clauses);
        this.inputClauses = clauses;
        this.comparator = comparator;
        this.style = style;
    }

    public ListScopeNode(List<DALNode> verificationExpressions, Type type, Comparator<Data> comparator, Style style) {
        this.inputExpressions = new ArrayList<DALNode>(verificationExpressions);
        this.verificationExpressions = this.inputExpressions;
        this.type = type;
        this.comparator = comparator;
        this.style = style;
    }

    public ListScopeNode(List<Clause<DALNode>> clauses) {
        this(clauses, SortGroupNode.NOP_COMPARATOR, Style.LIST);
    }

    private List<DALNode> getVerificationExpressions(Data.DataList list) {
        return this.verificationExpressions != null ? this.verificationExpressions : this.buildVerificationExpressions(list).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
    }

    private List<DALNode> buildVerificationExpressions(final Data.DataList list) {
        if (this.inputExpressions != null) {
            return this.inputExpressions;
        }
        return new ArrayList<DALNode>(){
            {
                List usefulInputClauses = ListScopeNode.this.inputClauses;
                if (ListScopeNode.this.type == Type.FIRST_N_ITEMS) {
                    usefulInputClauses.remove(usefulInputClauses.size() - 1);
                }
                if (ListScopeNode.this.type == Type.LAST_N_ITEMS) {
                    int negativeIndex = -1;
                    for (int i = usefulInputClauses.size() - 1; i >= 0; --i) {
                        this.add(0, ((Clause)usefulInputClauses.get(i)).expression((Node)DALExpression.expression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(negativeIndex--, SymbolNode.Type.BRACKET))));
                    }
                } else {
                    Zipped zipped = Zipped.zip((Iterable)usefulInputClauses, list.indexes());
                    zipped.forEachElement((clause, index) -> this.add(clause.expression((Node)DALExpression.expression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(index, SymbolNode.Type.BRACKET)))));
                    if (ListScopeNode.this.type == Type.ALL_ITEMS) {
                        if (zipped.hasLeft()) {
                            String message = String.format("Different list size\nExpected: <%d>\nActual: <%d>", usefulInputClauses.size(), zipped.index());
                            throw ListScopeNode.this.style == Style.ROW ? new DifferentCellSize(message, ListScopeNode.this.getPositionBegin()) : new AssertionFailure(message, ListScopeNode.this.getPositionBegin());
                        }
                        if (zipped.hasRight() && !list.infinite()) {
                            String message = String.format("Different list size\nExpected: <%d>\nActual: <%d>", usefulInputClauses.size(), list.size());
                            throw ListScopeNode.this.style == Style.ROW ? new DifferentCellSize(message, ListScopeNode.this.getPositionBegin()) : new AssertionFailure(message, ListScopeNode.this.getPositionBegin());
                        }
                    }
                }
            }
        };
    }

    @Override
    protected ExpectationFactory toVerify(final RuntimeContextBuilder.DALRuntimeContext context) {
        return (operator, actual) -> new ExpectationFactory.Expectation(){

            @Override
            public Data matches() {
                return this.equalTo();
            }

            @Override
            public Data equalTo() {
                try {
                    Data.DataList list = ExpressionException.opt1(actual::list).sort(ListScopeNode.this.comparator);
                    return list.wrap().execute(() -> ListScopeNode.this.type == Type.CONTAINS ? ListScopeNode.this.verifyContainElement(context, list) : ListScopeNode.this.verifyCorrespondingElement(context, ListScopeNode.this.getVerificationExpressions(list)));
                }
                catch (ListMappingElementAccessException e) {
                    throw ExpressionException.exception(expression -> e.toDalError(expression.left().getOperandPosition()));
                }
            }

            @Override
            public ExpectationFactory.Type type() {
                return ExpectationFactory.Type.LIST;
            }
        };
    }

    private List<DALNode> buildVerificationExpressions() {
        if (this.inputExpressions != null) {
            return this.inputExpressions;
        }
        return new ArrayList<DALNode>(){
            {
                if (ListScopeNode.this.type == Type.LAST_N_ITEMS) {
                    int negativeIndex = -1;
                    for (int i = ListScopeNode.this.inputClauses.size() - 1; i >= 0; --i) {
                        this.add(0, ((Clause)ListScopeNode.this.inputClauses.get(i)).expression((Node)DALExpression.expression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(negativeIndex--, SymbolNode.Type.BRACKET))));
                    }
                } else {
                    for (int i = 0; i < ListScopeNode.this.inputClauses.size(); ++i) {
                        this.add(((Clause)ListScopeNode.this.inputClauses.get(i)).expression((Node)DALExpression.expression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(i, SymbolNode.Type.BRACKET))));
                    }
                }
            }
        };
    }

    private Type guessType(List<Clause<DALNode>> clauses) {
        List isListEllipsis = clauses.stream().map(this::isListEllipsis).collect(Collectors.toList());
        long ellipsesCount = isListEllipsis.stream().filter(Boolean::booleanValue).count();
        if (ellipsesCount > 0L) {
            if (ellipsesCount == 1L) {
                if (((Boolean)isListEllipsis.get(0)).booleanValue()) {
                    return Type.LAST_N_ITEMS;
                }
                if (((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                    return Type.FIRST_N_ITEMS;
                }
            } else if (ellipsesCount == 2L && ((Boolean)isListEllipsis.get(0)).booleanValue() && ((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                return Type.CONTAINS;
            }
            throw new SyntaxException("Invalid ellipsis", ((DALNode)clauses.get(isListEllipsis.lastIndexOf(true)).expression(null)).getOperandPosition());
        }
        return Type.ALL_ITEMS;
    }

    @Override
    public String inspect() {
        if (this.type == Type.CONTAINS) {
            return this.inputClauses.stream().map(clause -> ((DALNode)clause.expression((Node)InputNode.INPUT_NODE)).inspect()).collect(Collectors.joining(", ", "[", "]"));
        }
        return this.buildVerificationExpressions().stream().map(DALNode::inspect).collect(Collectors.joining(", ", "[", "]"));
    }

    private Data verifyContainElement(RuntimeContextBuilder.DALRuntimeContext context, Data.DataList list) {
        Iterator<Integer> iterator = list.indexes().iterator();
        List<Clause<DALNode>> expected = this.trimFirstEllipsis();
        Data result = context.wrap(null);
        block4: for (int clauseIndex = 0; clauseIndex < expected.size(); ++clauseIndex) {
            Clause<DALNode> clause = expected.get(clauseIndex);
            try {
                while (true) {
                    int elementIndex = this.getElementIndex(clause, iterator);
                    try {
                        ((DALNode)clause.expression((Node)DALExpression.expression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(elementIndex, SymbolNode.Type.BRACKET)))).evaluate(context);
                        continue block4;
                    }
                    catch (AssertionFailure assertionFailure) {
                        continue;
                    }
                    break;
                }
            }
            catch (AssertionFailure exception) {
                throw this.style == Style.LIST ? exception : new RowAssertionFailure(clauseIndex, exception);
            }
        }
        return result;
    }

    private int getElementIndex(Clause<DALNode> clause, Iterator<Integer> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new AssertionFailure("No such element", ((DALNode)clause.expression((Node)InputNode.INPUT_NODE)).getOperandPosition());
    }

    private List<Clause<DALNode>> trimFirstEllipsis() {
        return this.inputClauses.subList(1, this.inputClauses.size() - 1);
    }

    private Data verifyCorrespondingElement(RuntimeContextBuilder.DALRuntimeContext context, List<DALNode> expressions) {
        Data result = context.wrap(null);
        if (this.style != Style.LIST) {
            for (int index = 0; index < expressions.size(); ++index) {
                try {
                    result = expressions.get(index).evaluateData(context);
                    continue;
                }
                catch (DifferentCellSize differentCellSize) {
                    throw new RowAssertionFailure(index, differentCellSize);
                }
                catch (DalException dalException) {
                    if (this.style == Style.TABLE) {
                        throw new ElementAssertionFailure(index, dalException);
                    }
                    throw dalException;
                }
            }
        } else {
            for (DALNode expression : expressions) {
                result = expression.evaluateData(context);
            }
        }
        return result;
    }

    private boolean isListEllipsis(Clause<DALNode> clause) {
        return clause.expression((Node)InputNode.INPUT_NODE) instanceof ListEllipsisNode;
    }

    static class DifferentCellSize
    extends AssertionFailure {
        public DifferentCellSize(String format, int position) {
            super(format, position);
        }
    }

    public static class ReverseOrder
    extends ListScopeNode {
        public ReverseOrder(List<Clause<DALNode>> clauses) {
            super(clauses, Comparator.comparing(Data::instance, Comparator.reverseOrder()), Style.LIST);
        }

        @Override
        public String inspect() {
            return "-" + super.inspect();
        }
    }

    public static class NatureOrder
    extends ListScopeNode {
        public NatureOrder(List<Clause<DALNode>> clauses) {
            super(clauses, Comparator.comparing(Data::instance, Comparator.naturalOrder()), Style.LIST);
        }

        @Override
        public String inspect() {
            return "+" + super.inspect();
        }
    }

    public static enum Style {
        LIST,
        TABLE,
        ROW;

    }

    public static enum Type {
        ALL_ITEMS,
        FIRST_N_ITEMS,
        LAST_N_ITEMS,
        CONTAINS;

    }
}

