/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.table.TransposedBody;
import com.github.leeonky.dal.ast.node.table.TransposedRowHeaderRow;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public class TransposedTableNode
extends DALNode {
    private final TransposedRowHeaderRow tableHead;
    private final TransposedBody tableBody;

    public TransposedTableNode(DALNode transposeTableHead, DALNode transposedTableBody) {
        this.tableHead = (TransposedRowHeaderRow)transposeTableHead;
        this.tableBody = ((TransposedBody)transposedTableBody).checkFormat(this.tableHead);
    }

    @Override
    protected ExpectationFactory toVerify(RuntimeContextBuilder.DALRuntimeContext context) {
        return (operator, actual) -> {
            final ExpectationFactory.Expectation expectation = this.transpose().convertToVerificationNode(actual, operator, context).toVerify(context).create(operator, actual);
            return new ExpectationFactory.Expectation(){

                @Override
                public Data matches() {
                    try {
                        return expectation.matches();
                    }
                    catch (RowAssertionFailure rowAssertionFailure) {
                        throw rowAssertionFailure.columnPositionException(TransposedTableNode.this);
                    }
                }

                @Override
                public Data equalTo() {
                    try {
                        return expectation.equalTo();
                    }
                    catch (RowAssertionFailure rowAssertionFailure) {
                        throw rowAssertionFailure.columnPositionException(TransposedTableNode.this);
                    }
                }

                @Override
                public ExpectationFactory.Type type() {
                    return expectation.type();
                }
            };
        };
    }

    public TableNode transpose() {
        return (TableNode)new TableNode(this.tableBody.transposeHead(), this.tableBody.transpose(this.tableHead)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return this.tableHead.inspect() + this.tableBody.inspect();
    }
}

