/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.EmptyTableRowType;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Body
extends DALNode {
    public static final RowType EMPTY_TABLE_ROW_TYPE = new EmptyTableRowType();
    private final List<Row> rows;
    private final RowType rowType;

    public Body(List<? extends DALNode> rows) {
        this(rows, InterpreterException.Position.Type.ROW);
    }

    public Body(List<? extends DALNode> rows, InterpreterException.Position.Type type) {
        this.rows = rows.stream().map(Row.class::cast).collect(Collectors.toList());
        this.rowType = this.resolveRowType(type);
    }

    public RowType resolveRowType(InterpreterException.Position.Type type) {
        return this.rows.stream().reduce(EMPTY_TABLE_ROW_TYPE, (last, rowNode) -> {
            try {
                return rowNode.mergeRowTypeBy((RowType)last);
            }
            catch (IllegalArgumentException ignored) {
                throw new SyntaxException("Row index should be consistent", rowNode.getPositionBegin(), type).multiPosition(this.rows.get(0).getPositionBegin(), type);
            }
        }, RowType::merge);
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(Row::inspect).collect(Collectors.joining("\n"));
    }

    public DALNode convertToVerificationNode(Data actual, DALOperator operator, Comparator<Data> comparator) {
        return this.rowType.constructVerificationNode(actual, this.rows.stream().map(rowNode -> rowNode.constructVerificationClause(operator, this.rowType)), comparator);
    }

    public Row dataRowSkipEllipsis(int indexSkipEllipsis) {
        return (Row)((Object)this.rows.stream().filter(Row::isData).collect(Collectors.toList()).get(indexSkipEllipsis));
    }

    public Body checkFormat(ColumnHeaderRow columnHeaderRow) {
        this.rows.forEach(columnHeaderRow::checkDataCellSize);
        return this;
    }
}

