/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.table.ColumnHeader;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ColumnHeaderRow
extends DALNode {
    private final List<ColumnHeader> headers;

    public ColumnHeaderRow(List<DALNode> headers) {
        this.headers = headers.stream().map(ColumnHeader.class::cast).collect(Collectors.toList());
    }

    @Override
    public String inspect() {
        return TableNode.printLine(this.headers) + "\n";
    }

    public Comparator<Data> collectComparator(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.headers.stream().sorted(ColumnHeader.bySequence()).map(headerNode -> headerNode.comparator(context)).reduce((comparator, other) -> comparator == SortGroupNode.NOP_COMPARATOR ? other : comparator.thenComparing(other)).orElse(SortGroupNode.NOP_COMPARATOR);
    }

    public ColumnHeader getHeader(int index) {
        if (index >= this.headers.size()) {
            return new ColumnHeader(SortGroupNode.NO_SEQUENCE, InputNode.INPUT_NODE, Optional.empty());
        }
        return this.headers.get(index);
    }

    public void checkDataCellSize(Row rowNode) {
        rowNode.checkSize(this.headers.size());
    }

    public ColumnHeaderRow merge(final ColumnHeaderRow columnHeaderRow) {
        return new ColumnHeaderRow((List<DALNode>)new ArrayList<DALNode>(){
            {
                this.addAll(ColumnHeaderRow.this.headers);
                this.addAll(columnHeaderRow.headers);
            }
        });
    }
}

