/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ListEllipsisNode;
import com.github.leeonky.dal.ast.node.ListScopeNode;
import com.github.leeonky.dal.ast.node.ObjectScopeNode;
import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.WildcardNode;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.DefaultIndexColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.RowHeader;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.function.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Row
extends DALNode {
    private final RowHeader rowHeader;
    private final List<Clause<DALNode>> cells;
    private final ColumnHeaderRow columnHeaderRow;

    public Row(DALNode rowHeader, DALNode cell, ColumnHeaderRow columnHeaderRow) {
        this(rowHeader, Collections.singletonList(n -> cell), columnHeaderRow);
    }

    public Row(DALNode rowHeader, List<Clause<DALNode>> clauses, ColumnHeaderRow columnHeaderRow) {
        this.rowHeader = (RowHeader)rowHeader;
        this.cells = new ArrayList<Clause<DALNode>>(clauses);
        this.columnHeaderRow = columnHeaderRow;
        this.setPositionBegin(clauses.get(clauses.size() - 1).getOperandPosition((Node)InputNode.INPUT_NODE));
    }

    @Override
    public String inspect() {
        String header = this.rowHeader.inspect();
        String data = TableNode.printLine(this.cells.stream().map(clause -> (DALNode)clause.expression((Node)InputNode.INPUT_NODE)).collect(Collectors.toList()));
        return header.isEmpty() ? data : header + " " + data;
    }

    public Clause<DALNode> constructVerificationClause(DALOperator operator, RowType rowType) {
        return input -> this.isEllipsis() ? this.firstCell() : this.rowHeader.makeExpressionWithOptionalIndexAndSchema(rowType, (DALNode)input, operator, this.expectedRow());
    }

    private DALNode expectedRow() {
        if (this.isRowWildcard()) {
            return this.firstCell();
        }
        if (this.columnHeaderRow instanceof DefaultIndexColumnHeaderRow) {
            return (DALNode)new ListScopeNode(this.cells, SortGroupNode.NOP_COMPARATOR, ListScopeNode.Style.ROW).setPositionBegin(this.getPositionBegin());
        }
        return (DALNode)new ObjectScopeNode(this.getCells()).setPositionBegin(this.getPositionBegin());
    }

    private DALNode firstCell() {
        return (DALNode)this.cells.get(0).expression(null);
    }

    private boolean isRowWildcard() {
        return this.cells.size() >= 1 && this.firstCell() instanceof WildcardNode;
    }

    private boolean isEllipsis() {
        return this.cells.size() >= 1 && this.firstCell() instanceof ListEllipsisNode;
    }

    private List<DALNode> getCells() {
        return new ArrayList<DALNode>(){
            {
                for (int i = 0; i < Row.this.cells.size(); ++i) {
                    this.add(((Clause)Row.this.cells.get(i)).expression((Node)Row.this.columnHeaderRow.getHeader(i).property()));
                }
            }
        };
    }

    public Row merge(final Row rowNode) {
        return (Row)new Row((DALNode)this.rowHeader, (List<Clause<DALNode>>)new ArrayList<Clause<DALNode>>(){
            {
                this.addAll(Row.this.cells);
                this.addAll(rowNode.cells);
            }
        }, this.columnHeaderRow.merge(rowNode.columnHeaderRow)).setPositionBegin(this.getPositionBegin());
    }

    public boolean isData() {
        return !this.isEllipsis();
    }

    public boolean specialRow() {
        return this.isEllipsis() || this.isRowWildcard();
    }

    public RowType mergeRowTypeBy(RowType rowType) {
        return rowType.merge(this.rowHeader.resolveRowType());
    }

    public void checkSize(int size) {
        if (!this.specialRow() && this.cells.size() != size) {
            throw new SyntaxException("Different cell size", this.cells.get(this.cells.size() - 1).getOperandPosition((Node)InputNode.INPUT_NODE));
        }
    }

    public DalException markPositionOnCells(DalException dalException) {
        this.rowHeader.position().ifPresent(position -> dalException.multiPosition((int)position, InterpreterException.Position.Type.COLUMN));
        return this.cells.stream().reduce(dalException, (e, cell) -> (DalException)e.multiPosition(((DALNode)cell.expression(null)).getPositionBegin(), InterpreterException.Position.Type.COLUMN), Extension.notAllowParallelReduce());
    }
}

