/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.IndexedElement;
import com.github.leeonky.dal.runtime.CollectionDALCollection;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.InfiniteCollectionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class DALCollectionBase<E>
implements DALCollection<E> {
    @Override
    public E getByIndex(int index) {
        try {
            if (index < 0) {
                return ((DALCollectionBase)this.requireLimitedCollection("Not support negative index in infinite collection")).getByPosition(this.size() + index);
            }
            return this.getByPosition(index - this.firstIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds (%d), first index is: %d", index, this.firstIndex()));
        }
    }

    @Override
    public int firstIndex() {
        return 0;
    }

    @Override
    public DALCollectionBase<E> requireLimitedCollection(String message) {
        if (this.infinite()) {
            throw new InfiniteCollectionException(message);
        }
        return this;
    }

    protected abstract E getByPosition(int var1);

    @Override
    public List<E> collect() {
        return ((DALCollectionBase)this.requireLimitedCollection("Not supported for infinite collection")).stream().map(IndexedElement::value).collect(Collectors.toList());
    }

    @Override
    public Stream<E> values() {
        return this.stream().map(IndexedElement::value);
    }

    @Override
    public Stream<Integer> indexes() {
        return this.stream().map(IndexedElement::index);
    }

    @Override
    public <R> DALCollectionBase<R> map(final IndexedElement.Mapper<? super E, ? extends R> mapper) {
        return new DALCollectionBase<R>(){

            @Override
            public int size() {
                return DALCollectionBase.this.size();
            }

            @Override
            public int firstIndex() {
                return DALCollectionBase.this.firstIndex();
            }

            @Override
            protected R getByPosition(int position) {
                return mapper.apply(position + this.firstIndex(), DALCollectionBase.this.getByPosition(position));
            }

            @Override
            public Iterator<IndexedElement<R>> iterator() {
                return new Iterator<IndexedElement<R>>(){
                    final Iterator<IndexedElement<E>> iterator;
                    {
                        this.iterator = DALCollectionBase.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IndexedElement<R> next() {
                        return this.iterator.next().map(mapper);
                    }
                };
            }

            @Override
            public boolean infinite() {
                return DALCollectionBase.this.infinite();
            }
        };
    }

    @Override
    public Stream<IndexedElement<E>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public boolean infinite() {
        return false;
    }

    @Override
    public DALCollection<Object> limit(int size) {
        return new CollectionDALCollection<Object>((Collection)this.values().limit(size).collect(Collectors.toList())){

            @Override
            public int firstIndex() {
                return DALCollectionBase.this.firstIndex();
            }
        };
    }
}

