/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.runtime.AutoMappingList;
import com.github.leeonky.dal.runtime.CollectionDALCollection;
import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.CurryingMethodGroup;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.InstanceCurryingMethod;
import com.github.leeonky.dal.runtime.ListMappingElementAccessException;
import com.github.leeonky.dal.runtime.PartialObject;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.inspector.DumpingBuffer;
import com.github.leeonky.util.Classes;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Data {
    private final SchemaType schemaType;
    private final RuntimeContextBuilder.DALRuntimeContext context;
    private final Object instance;
    private DataList list;

    public Data(Object instance, RuntimeContextBuilder.DALRuntimeContext context, SchemaType schemaType) {
        this.instance = instance;
        this.schemaType = schemaType;
        this.context = context;
    }

    public Object instance() {
        return this.instance;
    }

    public Set<Object> fieldNames() {
        return this.context.findPropertyReaderNames(this.instance);
    }

    public boolean isList() {
        return this.context.isRegisteredList(this.instance) || this.instance != null && this.instance.getClass().isArray();
    }

    public DataList list() {
        if (this.list == null) {
            if (!this.isList()) {
                throw new RuntimeException(String.format("Invalid input value, expect a List but: %s", this.dumpAll().trim()));
            }
            this.list = new DataList(this.context.createCollection(this.instance));
        }
        return this.list;
    }

    public boolean isNull() {
        return this.context.isNull(this.instance);
    }

    public Data getValue(List<Object> propertyChain) {
        return propertyChain.isEmpty() ? this : this.getValue(propertyChain.get(0)).getValue(propertyChain.subList(1, propertyChain.size()));
    }

    public Data getValue(Object propertyChain) {
        try {
            List<Object> chain = this.schemaType.access(propertyChain).getPropertyChainBefore(this.schemaType);
            if (chain.size() == 1 && chain.get(0).equals(propertyChain)) {
                return new Data(this.getPropertyValue(propertyChain), this.context, this.propertySchema(propertyChain));
            }
            return this.getValue(chain);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PropertyAccessException(ex.getMessage(), ex);
        }
        catch (ListMappingElementAccessException ex) {
            throw new PropertyAccessException(ex.toDalError(0).getMessage(), ex.propertyAccessException().getCause());
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format("Get property `%s` failed, property can be:\n  1. public field\n  2. public getter\n  3. public no args method\n  4. Map key value\n  5. customized type getter\n  6. static method extension\n%s%s", propertyChain, e.getMessage(), this.listMappingMessage(this, propertyChain)), e);
        }
    }

    private String listMappingMessage(Data data, Object symbol) {
        return data.isList() ? String.format("\nImplicit list mapping is not allowed in current version of DAL, use `%s[]` instead or specify index in []", symbol) : "";
    }

    private Object getPropertyValue(Object property) {
        return this.isList() ? this.fetchFromList(property) : this.context.getPropertyValue(this, property);
    }

    private Object fetchFromList(Object property) {
        return property instanceof String ? this.context.getPropertyValue(this, property) : this.list().getByIndex((Integer)property);
    }

    private SchemaType propertySchema(Object property) {
        if (this.isList() && property instanceof String) {
            return this.schemaType.mappingAccess(property);
        }
        return this.schemaType.access(property);
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.schemaType.firstFieldFromAlias(alias);
    }

    public Data convert(Class<?> target) {
        return new Data(this.context.getConverter().convert(target, this.instance), this.context, this.schemaType);
    }

    public Data map(Function<Object, Object> mapper) {
        return new Data(mapper.apply(this.instance), this.context, this.schemaType);
    }

    public Data filter(String prefix) {
        FilteredObject filteredObject = new FilteredObject();
        this.fieldNames().stream().filter(String.class::isInstance).map(String.class::cast).filter((? super T field) -> field.startsWith(prefix)).forEach(fieldName -> filteredObject.put(fieldName.substring(prefix.length()), this.getValue(fieldName).instance()));
        return new Data(filteredObject, this.context, this.schemaType);
    }

    public String dumpAll() {
        return DumpingBuffer.rootContext(this.context).dump(this).content();
    }

    public String dumpValue() {
        return DumpingBuffer.rootContext(this.context).dumpValue(this).content();
    }

    public <T> T execute(Supplier<T> supplier) {
        return this.context.pushAndExecute(this, supplier);
    }

    public Optional<CurryingMethod> currying(Object property) {
        return this.currying(this.instance, property);
    }

    private Optional<CurryingMethod> currying(Object instance, Object property) {
        List<InstanceCurryingMethod> methods = this.context.methodToCurrying(Classes.named(instance.getClass()), property).stream().map((? super T method) -> CurryingMethod.createCurryingMethod(instance, method, this.context.getConverter())).collect(Collectors.toList());
        if (!methods.isEmpty()) {
            return Optional.of(new CurryingMethodGroup(methods, null));
        }
        return this.context.getImplicitObject(instance).flatMap(obj -> this.currying(obj, property));
    }

    public class DataList
    extends DALCollection.Decorated<Object> {
        public DataList(DALCollection<Object> origin) {
            super(origin);
        }

        public DALCollection<Data> wraps() {
            return this.map((index, e) -> new Data(e, Data.this.context, Data.this.schemaType.access(index)));
        }

        public Data listMap(Object property) {
            return new Data(this.listMap((Data data) -> data.getValue(property).instance()), Data.this.context, Data.this.propertySchema(property));
        }

        public AutoMappingList listMap(Function<Data, Object> mapper) {
            return new AutoMappingList(mapper, this.wraps());
        }

        public DataList sort(Comparator<Data> comparator) {
            if (comparator != SortGroupNode.NOP_COMPARATOR) {
                return new DataList((DALCollection<Object>)new CollectionDALCollection<Object>((Collection)this.wraps().collect().stream().sorted(comparator).map(Data::instance).collect(Collectors.toList())){

                    @Override
                    public int firstIndex() {
                        return DataList.this.firstIndex();
                    }

                    @Override
                    public boolean infinite() {
                        return DataList.this.infinite();
                    }
                });
            }
            return this;
        }

        public Data wrap() {
            return new Data(this, Data.this.context, Data.this.schemaType);
        }
    }

    static class FilteredObject
    extends LinkedHashMap<String, Object>
    implements PartialObject {
        FilteredObject() {
        }
    }
}

