/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.regex.Pattern;

public class RegexNode
extends DALNode {
    private final Pattern pattern;

    public RegexNode(String regex) {
        this.pattern = Pattern.compile(regex, 32);
    }

    @Override
    public String inspect() {
        return String.format("/%s/", this.pattern.toString());
    }

    @Override
    protected ExpectationFactory toVerify(RuntimeContextBuilder.DALRuntimeContext context) {
        return (operator, actual) -> new ExpectationFactory.Expectation(){

            @Override
            public Data matches() {
                String converted = ExpressionException.opt2(() -> (String)actual.convert(String.class).instance());
                if (RegexNode.this.pattern.matcher(converted).matches()) {
                    return actual;
                }
                throw new AssertionFailure(String.format("Expected to match: /%s/\nActual: <%s> converted from: %s", RegexNode.this.pattern, converted, actual.dumpAll()), RegexNode.this.getPositionBegin());
            }

            @Override
            public Data equalTo() {
                if (actual.instance() instanceof String) {
                    if (RegexNode.this.pattern.matcher((String)actual.instance()).matches()) {
                        return actual;
                    }
                    throw new AssertionFailure(String.format("Expected to match: /%s/\nActual: <%s>", RegexNode.this.pattern, actual.instance()), RegexNode.this.getPositionBegin());
                }
                throw ExpressionException.illegalOperationRuntimeException("Operator = before regex need a string input value");
            }

            @Override
            public ExpectationFactory.Type type() {
                return ExpectationFactory.Type.REGEX;
            }
        };
    }
}

