/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.Body;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class TableNode
extends DALNode {
    private final ColumnHeaderRow columnHeaderRow;
    private final Body body;

    public TableNode(ColumnHeaderRow columnHeaderRow, Body body) {
        this.columnHeaderRow = columnHeaderRow;
        this.body = body.checkFormat(this.columnHeaderRow);
        this.setPositionBegin(columnHeaderRow.getPositionBegin());
    }

    @Override
    protected ExpectationFactory toVerify(RuntimeContextBuilder.DALRuntimeContext context) {
        return (operator, actual) -> {
            final ExpectationFactory.Expectation verificationExpectation = this.convertToVerificationNode(actual, operator, context).toVerify(context).create(operator, actual);
            return new ExpectationFactory.Expectation(){

                @Override
                public Data matches() {
                    try {
                        return verificationExpectation.matches();
                    }
                    catch (RowAssertionFailure rowAssertionFailure) {
                        throw rowAssertionFailure.linePositionException(TableNode.this);
                    }
                }

                @Override
                public Data equalTo() {
                    try {
                        return verificationExpectation.equalTo();
                    }
                    catch (RowAssertionFailure rowAssertionFailure) {
                        throw rowAssertionFailure.linePositionException(TableNode.this);
                    }
                }

                @Override
                public ExpectationFactory.Type type() {
                    return verificationExpectation.type();
                }
            };
        };
    }

    public DALNode convertToVerificationNode(Data actual, DALOperator operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return (DALNode)this.body.convertToVerificationNode(actual, operator, this.columnHeaderRow.collectComparator(context)).setPositionBegin(this.getPositionBegin());
    }

    @Override
    public String inspect() {
        return (this.columnHeaderRow.inspect() + this.body.inspect()).trim();
    }

    public static String printLine(List<? extends DALNode> nodes) {
        return nodes.stream().map(DALNode::inspect).collect(Collectors.joining(" | ", "| ", " |"));
    }

    public Row fetchDataRowSkipEllipsis(int indexSkipEllipsis) {
        return this.body.dataRowSkipEllipsis(indexSkipEllipsis);
    }
}

