/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.ParameterValue;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.Suppressor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class InstanceCurryingMethod
implements CurryingMethod {
    protected final Object instance;
    protected final Method method;
    protected final Converter converter;
    protected final List<ParameterValue> parameterValues = new ArrayList<ParameterValue>();

    protected InstanceCurryingMethod(Object instance, Method method, Converter converter) {
        this.method = method;
        this.instance = instance;
        this.converter = converter;
    }

    @Override
    public InstanceCurryingMethod call(Object arg) {
        InstanceCurryingMethod curryingMethod = this.clone();
        curryingMethod.parameterValues.addAll(this.parameterValues);
        curryingMethod.parameterValues.add(new ParameterValue(this.currentPositionParameter(), arg));
        return curryingMethod;
    }

    private Parameter currentPositionParameter() {
        return this.method.getParameters()[this.parameterValues.size() + this.parameterOffset()];
    }

    protected int parameterOffset() {
        return 0;
    }

    protected InstanceCurryingMethod clone() {
        return new InstanceCurryingMethod(this.instance, this.method, this.converter);
    }

    private String parameterInfo() {
        List parameters = Arrays.stream(this.method.getParameters()).map(Parameter::toString).collect(Collectors.toList());
        int argPosition = this.parameterValues.size() + this.parameterOffset();
        if (parameters.size() > 0) {
            parameters.set(argPosition, "> " + (String)parameters.get(argPosition));
        }
        return parameters.stream().collect(Collectors.joining(",\n", String.format("%s.%s(\n", this.method.getDeclaringClass().getName(), this.method.getName()), "\n)"));
    }

    public boolean allParamsSameType() {
        return this.testParameterTypes(ParameterValue::isSameType);
    }

    private boolean testParameterTypes(Predicate<ParameterValue> checking) {
        return this.isArgCountEnough() && this.parameterValues.stream().allMatch(checking);
    }

    private boolean isArgCountEnough() {
        return this.method.getParameterCount() - this.parameterOffset() == this.parameterValues.size();
    }

    public boolean allParamsBaseType() {
        return this.testParameterTypes(ParameterValue::isSuperType);
    }

    public boolean allParamsConvertible() {
        return this.testParameterTypes(parameterValue -> parameterValue.isConvertibleType(this.converter));
    }

    @Override
    public Object resolve() {
        return Suppressor.get(() -> this.method.invoke(this.instance, this.parameterValues.stream().map(parameterValue -> parameterValue.getArg(this.converter)).collect(Collectors.toList()).toArray()));
    }

    @Override
    public Set<Object> fetchArgRange(RuntimeContextBuilder runtimeContextBuilder) {
        BiFunction<Object, List<Object>, List<Object>> rangeFactory = runtimeContextBuilder.fetchCurryingMethodArgRange(this.method);
        if (rangeFactory != null) {
            return new LinkedHashSet<Object>((Collection)rangeFactory.apply(this.instance, this.parameterValues.stream().map(parameterValue -> parameterValue.getArg(this.converter)).collect(Collectors.toList())));
        }
        System.err.printf("No arg range for %s, give the range or use `:`%n", this.parameterInfo());
        return Collections.emptySet();
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean isSameInstanceType() {
        return true;
    }

    @Override
    public Object convertToArgType(Object obj) {
        return this.converter.convert(this.currentPositionParameter().getType(), obj);
    }
}

