/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.IndexedElement;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.DALCollectionBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public class IterableDALCollection<E>
extends DALCollectionBase<E> {
    private final Iterator<E> iterator;
    private final List<E> cached = new ArrayList();

    public IterableDALCollection(Iterable<E> iterable) {
        this.iterator = StreamSupport.stream(iterable.spliterator(), false).iterator();
    }

    @Override
    public Iterator<IndexedElement<E>> iterator() {
        return new Iterator<IndexedElement<E>>(){
            private int index;
            private int position;
            {
                this.index = IterableDALCollection.this.firstIndex();
                this.position = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.position < IterableDALCollection.this.cached.size()) {
                    return true;
                }
                return IterableDALCollection.this.iterator.hasNext();
            }

            @Override
            public IndexedElement<E> next() {
                if (this.position < IterableDALCollection.this.cached.size()) {
                    return new IndexedElement(this.index++, IterableDALCollection.this.cached.get(this.position++));
                }
                ++this.position;
                return new IndexedElement<Object>(this.index++, IterableDALCollection.this.getNext());
            }
        };
    }

    private E getNext() {
        E next = this.iterator.next();
        this.cached.add(next);
        return next;
    }

    @Override
    protected E getByPosition(int position) {
        if (position < this.cached.size()) {
            return this.cached.get(position);
        }
        while (this.iterator.hasNext()) {
            this.getNext();
            if (position >= this.cached.size()) continue;
            return this.cached.get(position);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return (int)StreamSupport.stream(this.requireLimitedCollection("Not supported for infinite collection").spliterator(), false).count();
    }

    @Override
    public DALCollection<E> filter(Predicate<E> predicate) {
        return new IterableDALCollection<E>(() -> Spliterators.iterator(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator, 16), false).filter(predicate).spliterator())){

            @Override
            public int firstIndex() {
                return IterableDALCollection.this.firstIndex();
            }
        };
    }
}

