/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.checker;

import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.StringWithPosition;

public class CheckingContext {
    private final Data originalExpected;
    private final Data originalActual;
    private final Data expected;
    private final Data actual;

    public Data getOriginalActual() {
        return this.originalActual;
    }

    public Data getOriginalExpected() {
        return this.originalExpected;
    }

    public CheckingContext(Data originalExpected, Data originalActual, Data expected, Data actual) {
        this.originalExpected = originalExpected;
        this.originalActual = originalActual;
        this.expected = expected;
        this.actual = actual;
    }

    public boolean objectNotEquals() {
        return !Calculator.equals(this.actual, this.expected);
    }

    public String messageEqualTo() {
        return this.verificationMessage("Expected to be equal to: ", "");
    }

    public String messageMatch() {
        return this.verificationMessage("Expected to match: ", this.actual.instance() == this.originalActual.instance() ? "" : " converted from: " + this.originalActual.dumpAll());
    }

    public String verificationMessage(String prefix, String actualPostfix) {
        String actual = this.actual.dumpAll() + actualPostfix;
        String expected = this.expected.dumpAll();
        int position = TextUtil.differentPosition(expected, actual);
        return new StringWithPosition(actual).position(position).result(new StringWithPosition(expected).position(position).result(prefix) + "\nActual: ");
    }

    public String cannotCompare() {
        return String.format("Cannot compare between %s\nand %s", this.actual.dumpAll(), this.expected.dumpAll());
    }

    public Data getExpected() {
        return this.expected;
    }

    public Data getActual() {
        return this.actual;
    }
}

