/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.RowHeader;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public class ConstValueNode
extends DALNode {
    private final Object value;

    public ConstValueNode(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.value;
    }

    @Override
    public String inspect() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return String.format("'%s'", this.value);
        }
        return this.value.toString();
    }

    @Override
    public RowType guessTableHeaderType() {
        return RowHeader.SPECIFY_INDEX;
    }

    @Override
    public boolean needPostBlankWarningCheck() {
        return true;
    }
}

