/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.DataRemarkNode;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.ast.node.GroupExpression;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ObjectScopeNode;
import com.github.leeonky.dal.ast.node.PropertyThis;
import com.github.leeonky.dal.ast.node.table.RowHeader;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Expression;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.util.InvocationException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class DALExpression
extends DALNode
implements Expression<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator>,
ExecutableNode {
    private final DALNode left;
    private final DALOperator operator;
    private final DALNode right;

    private DALExpression(DALNode left, DALOperator operator, DALNode right) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        this.setPositionBegin(operator.getPosition());
    }

    public static DALNode expression(DALNode left, DALOperator operator, DALNode right) {
        if (left instanceof GroupExpression) {
            return ((GroupExpression)left).append(operator, right);
        }
        if (right instanceof GroupExpression) {
            return ((GroupExpression)right).insert(left, operator);
        }
        return (DALNode)new DALExpression(left, operator, right).applyPrecedence(DALExpression::new);
    }

    public DALNode left() {
        return this.left;
    }

    public DALNode right() {
        return this.right;
    }

    public DALOperator operator() {
        return this.operator;
    }

    @Override
    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            return this.operator.calculateData(this, context);
        }
        catch (InterpreterException e) {
            throw e;
        }
        catch (ExpressionException ex) {
            throw ex.rethrow(this);
        }
        catch (AssertionError error) {
            throw new AssertionFailure(((Throwable)((Object)error)).getMessage(), this.right().getPositionBegin());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), this.operator().getPosition(), (Throwable)new InvocationException((Throwable)e));
        }
    }

    @Override
    public String inspect() {
        return this.operator.inspect(this.left == null ? null : this.left.inspect(), this.right.inspect());
    }

    @Override
    public Object getRootSymbolName() {
        return this.left instanceof InputNode || this.isRootPropertyThis() ? this.right.getRootSymbolName() : this.left.getRootSymbolName();
    }

    private boolean isRootPropertyThis() {
        return this.left instanceof DALExpression && ((DALExpression)this.left).right() instanceof PropertyThis;
    }

    public int getOperandPosition() {
        return this.right.getPositionBegin();
    }

    @Override
    public List<Object> propertyChain() {
        return new ArrayList<Object>(){
            {
                this.addAll(DALExpression.this.left.propertyChain());
                this.addAll(DALExpression.this.right.propertyChain());
            }
        };
    }

    @Override
    public Stream<Object> collectFields(Data data) {
        if (((DALExpression)this.left()).right() instanceof PropertyThis && this.right() instanceof ObjectScopeNode) {
            return this.right().collectFields(data);
        }
        return super.collectFields(data);
    }

    @Override
    public Data getValue(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.pushAndExecute(data, () -> this.evaluateData(context));
    }

    public int getPositionBegin() {
        if (this.left == null || this.left instanceof InputNode) {
            return super.getPositionBegin();
        }
        return Math.min(super.getPositionBegin(), this.left.getPositionBegin());
    }

    @Override
    public RowType guessTableHeaderType() {
        if (this.left() instanceof InputNode && this.right() instanceof DataRemarkNode) {
            return RowHeader.DEFAULT_INDEX;
        }
        return RowHeader.SPECIFY_PROPERTY;
    }

    @Override
    public boolean needPostBlankWarningCheck() {
        return true;
    }
}

