/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectScopeNode
extends DALNode {
    private final List<DALNode> verificationExpressions = new ArrayList<DALNode>();
    private final boolean isObjectWildcard;

    public ObjectScopeNode(List<DALNode> expressions) {
        this.verificationExpressions.addAll(expressions);
        this.isObjectWildcard = false;
    }

    public ObjectScopeNode(DALNode ignore) {
        this.isObjectWildcard = true;
    }

    @Override
    public String inspect() {
        return String.format("{%s}", this.isObjectWildcard ? "..." : this.verificationExpressions.stream().map(DALNode::inspect).collect(Collectors.joining(", ")));
    }

    @Override
    protected ExpectationFactory toVerify(final RuntimeContextBuilder.DALRuntimeContext context) {
        return (operator, actual) -> new ExpectationFactory.Expectation(){

            @Override
            public Data matches() {
                if (ObjectScopeNode.this.verificationExpressions.isEmpty() && !ObjectScopeNode.this.isObjectWildcard) {
                    throw new SyntaxException("Should use `{...}` to verify any non null object", ObjectScopeNode.this.getPositionBegin());
                }
                if (ExpressionException.opt1(actual::isNull).booleanValue()) {
                    throw new AssertionFailure("The input value is null", ObjectScopeNode.this.getOperandPosition());
                }
                return actual.execute(() -> {
                    Data result = context.wrap(null);
                    for (DALNode expression : ObjectScopeNode.this.verificationExpressions) {
                        result = expression.evaluateData(context);
                    }
                    return result;
                });
            }

            @Override
            public Data equalTo() {
                if (ExpressionException.opt1(actual::isNull).booleanValue()) {
                    throw new AssertionFailure("The input value is null", ObjectScopeNode.this.getOperandPosition());
                }
                Data execute = actual.execute(() -> {
                    Data result = context.wrap(null);
                    for (DALNode expression : ObjectScopeNode.this.verificationExpressions) {
                        result = expression.evaluateData(context);
                    }
                    return result;
                });
                Set dataFields = ObjectScopeNode.this.collectUnexpectedFields(actual, context);
                if (!dataFields.isEmpty()) {
                    throw ExpressionException.exception(expression -> {
                        String element = expression.left().inspect();
                        return new AssertionFailure(String.format("Unexpected fields %s%s", dataFields.stream().map(s -> s instanceof String ? String.format("`%s`", s) : s.toString()).collect(Collectors.joining(", ")), element.isEmpty() ? "" : " in " + element), expression.operator().getPosition());
                    });
                }
                return execute;
            }

            @Override
            public ExpectationFactory.Type type() {
                return ExpectationFactory.Type.OBJECT;
            }
        };
    }

    private Set<Object> collectUnexpectedFields(final Data data, final RuntimeContextBuilder.DALRuntimeContext context) {
        return new LinkedHashSet<Object>(data.fieldNames()){
            {
                super(x0);
                Stream.concat(ObjectScopeNode.this.collectFields(data), context.collectPartialProperties(data).stream()).map(obj -> ObjectScopeNode.this.convertFiled(data, obj)).forEach(this::remove);
            }
        };
    }

    private Object convertFiled(Data data, Object obj) {
        return data.instance() instanceof CurryingMethod ? ((CurryingMethod)data.instance()).convertToArgType(obj) : obj;
    }

    @Override
    public Stream<Object> collectFields(Data data) {
        return this.verificationExpressions.stream().flatMap(expression -> expression.collectFields(data));
    }
}

