/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.compiler.Notations;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class SortSymbolNode
extends DALNode {
    private static final Map<String, Type> types = new HashMap<String, Type>(){
        {
            this.put(Notations.SEQUENCE_AZ.getLabel(), Type.AZ);
            this.put(Notations.SEQUENCE_AZ_2.getLabel(), Type.AZ);
            this.put(Notations.SEQUENCE_ZA.getLabel(), Type.ZA);
            this.put(Notations.SEQUENCE_ZA_2.getLabel(), Type.ZA);
        }
    };
    private final String label;
    private final Type type;

    public SortSymbolNode(String label) {
        this.label = label;
        this.type = types.get(label);
    }

    @Override
    public String inspect() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        AZ,
        ZA{

            @Override
            <T> Comparator<T> azOrZa(Comparator<T> comparator) {
                return comparator.reversed();
            }
        };


        <T> Comparator<T> azOrZa(Comparator<T> comparator) {
            return comparator;
        }
    }
}

