/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.Body;
import com.github.leeonky.dal.ast.node.table.ColumnHeaderRow;
import com.github.leeonky.dal.ast.node.table.Row;
import com.github.leeonky.dal.ast.node.table.TransposedRow;
import com.github.leeonky.dal.ast.node.table.TransposedRowHeaderRow;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TransposedBody
extends DALNode {
    private final List<TransposedRow> rows;

    public TransposedBody(List<DALNode> rows) {
        this.rows = rows.stream().map(TransposedRow.class::cast).collect(Collectors.toList());
    }

    public TransposedBody checkFormat(TransposedRowHeaderRow tableHead) {
        this.checkCellSize(tableHead);
        this.replaceEmptyCell();
        return this;
    }

    private void replaceEmptyCell() {
        TransposedRow firstRow = this.rows.get(0);
        this.rows.stream().skip(1L).forEach(row -> row.replaceEmptyCell(firstRow));
    }

    private void checkCellSize(TransposedRowHeaderRow tableHead) {
        this.rows.forEach(tableHead::checkSize);
        Map<Integer, List<TransposedRow>> rowsByCount = this.rows.stream().collect(Collectors.groupingBy(TransposedRow::cellCount));
        if (rowsByCount.size() > 1) {
            throw new SyntaxException("Different cell size", new ArrayList<List<TransposedRow>>(rowsByCount.values()).get(1).get(0).getPositionBegin(), InterpreterException.Position.Type.ROW);
        }
    }

    public Body transpose(TransposedRowHeaderRow tableHead) {
        return new Body(this.rows.stream().map(rowNode -> rowNode.transpose(tableHead)).reduce(this::merge).orElse(Collections.emptyList()), InterpreterException.Position.Type.CHAR);
    }

    private List<Row> merge(final List<Row> rows1, final List<Row> rows2) {
        return new ArrayList<Row>(){
            {
                for (int i = 0; i < rows1.size(); ++i) {
                    this.add(((Row)((Object)rows1.get(i))).merge((Row)((Object)rows2.get(i))));
                }
            }
        };
    }

    public ColumnHeaderRow transposeHead() {
        return new ColumnHeaderRow(this.rows.stream().map(TransposedRow::getHeader).collect(Collectors.toList()));
    }

    @Override
    public String inspect() {
        return this.rows.stream().map(TransposedRow::inspect).collect(Collectors.joining("\n"));
    }
}

