/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.text;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.text.TextBlockAttributeListNode;
import com.github.leeonky.dal.ast.node.text.TextBlockNotationNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.util.function.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NotationAttributeNode
extends DALNode {
    private final TextBlockAttributeListNode attributeList;
    private final TextBlockNotationNode notation;

    public NotationAttributeNode(TextBlockNotationNode notation, TextBlockAttributeListNode attributeList) {
        this.notation = notation;
        this.attributeList = attributeList;
    }

    @Override
    public String inspect() {
        return (this.notation.inspect() + " " + this.attributeList.inspect()).trim();
    }

    public String endNotation() {
        return this.notation.inspect();
    }

    public Object text(List<Character> content, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.attributeList.getFormatter(context).format(this.resolveToText(content), context);
    }

    private String resolveToText(List<Character> content) {
        List<String> lines = this.joinToLines(content);
        int indent = this.resolveIndent(lines);
        List collect = lines.stream().map(s -> s.equals("") ? s : this.processLine((String)s, indent)).collect(Collectors.toList());
        return collect.size() == 1 && ((String)collect.get(0)).equals("") ? "\n" : String.join((CharSequence)"\n", collect);
    }

    private int resolveIndent(List<String> lines) {
        return lines.stream().filter(Extension.not(String::isEmpty)).mapToInt(s -> {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == ' ') continue;
                return i;
            }
            return 0;
        }).map(i -> Math.min(i, this.notation.getIndent())).min().orElse(0);
    }

    private List<String> joinToLines(List<Character> content) {
        List<String> lines = TextUtil.lines(TextUtil.join(content) + ' ');
        return new ArrayList<String>(lines.subList(0, lines.size() - 1));
    }

    private String processLine(String s, int indent) {
        return s.substring(indent);
    }
}

