/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.opt;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.ast.node.SchemaComposeNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExclamationData;
import com.github.leeonky.dal.runtime.Operators;
import com.github.leeonky.dal.runtime.RemarkData;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Notation;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Factory {
    public static DALOperator logical(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.SupplierSupplierData logical) {
        return new Operator(200, notation, ExpressionContextData.adapt(logical), true, Operators.NA);
    }

    public static DALOperator plusSub(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.DataOptDataContextData plusSub, Operators type) {
        return new Operator(300, notation, ExpressionContextData.adapt(plusSub), false, type);
    }

    public static DALOperator mulDiv(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.DataOptDataContextData mulDiv, Operators type) {
        return new Operator(400, notation, ExpressionContextData.adapt(mulDiv), false, type);
    }

    public static DALOperator comparator(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData operation) {
        return new Operator(220, notation, operation, true, Operators.NA);
    }

    public static DALOperator unary(final Notation<?, ?, ?, ?, ?> notation, ExpressionContextData unary) {
        return new Operator(500, notation, unary, true, Operators.NA){

            @Override
            public String inspect(String node1, String node2) {
                return notation.getLabel() + node2;
            }
        };
    }

    public static DALOperator executable(Notation<?, ?, ?, ?, ?> notation) {
        return new DALOperator(501, notation.getLabel(), false, Operators.NA){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((ExecutableNode)((Object)expression.right())).getValue(expression.left(), context);
            }

            @Override
            public String inspect(String node1, String node2) {
                return String.format("%s%s%s", node1, this.label, node2);
            }
        };
    }

    public static DALOperator is() {
        return new DALOperator(210, Notations.Operators.IS.getLabel(), true, Operators.NA){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((SchemaComposeNode)expression.right()).verify(expression.left(), context);
            }
        };
    }

    public static DALOperator which() {
        return new DALOperator(100, Notations.Operators.WHICH.getLabel(), true, Operators.NA){

            @Override
            public Object calculate(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                try {
                    return expression.left().evaluateData(context).execute(() -> expression.right().evaluate(context));
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException(e.getMessage(), this.getPosition());
                }
            }
        };
    }

    public static DALOperator dataRemark() {
        return new DALOperator(501, "DATA_REMARK", false, Operators.NA){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.invokeDataRemark(new RemarkData(expression.left().evaluateData(context), context, expression.right().inspect()));
            }

            @Override
            public String inspect(String node1, String node2) {
                return node1 + "(" + node2 + ")";
            }
        };
    }

    public static DALOperator exclamation() {
        return new DALOperator(501, "EXCLAMATION", false, Operators.NA){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.invokeExclamations(new ExclamationData(expression.left().evaluateData(context), expression.left(), expression.right(), context));
            }

            @Override
            public String inspect(String node1, String node2) {
                return node1 + node2;
            }
        };
    }

    public static DALOperator equal() {
        return new VerificationOperator(Notations.Operators.EQUAL.getLabel(), Operators.EQUAL);
    }

    public static DALOperator match() {
        return new VerificationOperator(Notations.Operators.MATCHER.getLabel(), Operators.MATCH);
    }

    public static class VerificationOperator
    extends DALOperator {
        public VerificationOperator(String label, Operators type) {
            super(210, label, true, type);
        }

        @Override
        public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
            return expression.right().verify(expression.operator(), expression.left(), context);
        }

        @Override
        public String inspect(String node1, String node2) {
            return String.format("%s%s %s", node1, this.label, node2);
        }
    }

    public static interface QuadFunction<T1, T2, T3, T4, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4);
    }

    static class Operator
    extends DALOperator {
        private final ExpressionContextData operation;

        public Operator(int precedence, Notation<?, ?, ?, ?, ?> notation, ExpressionContextData operation, boolean needInspect, Operators type) {
            super(precedence, notation.getLabel(), needInspect, type);
            this.operation = operation;
        }

        @Override
        public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
            return (Data)this.operation.apply(expression, context);
        }
    }

    public static interface ExpressionContextData
    extends BiFunction<DALExpression, RuntimeContextBuilder.DALRuntimeContext, Data> {
        public static ExpressionContextData adapt(SupplierSupplierData operation) {
            return (expression, context) -> context.wrap(((Data)operation.apply(() -> expression.left().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), () -> expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context))).instance());
        }

        public static ExpressionContextData adapt(DataDataObject operation) {
            return (expression, context) -> context.wrap(operation.apply(expression.left().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context)));
        }

        public static ExpressionContextData adapt(DataOptDataContextData operation) {
            return (expression, context) -> (Data)operation.apply(expression.left().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), expression.operator(), expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), context);
        }

        public static ExpressionContextData adapt(DataContextData operation) {
            return (expression, context) -> (Data)operation.apply(expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), context);
        }

        public static ExpressionContextData adapt(DataObject operation) {
            return (expression, context) -> context.wrap(operation.apply(expression.right().evaluate((RuntimeContextBuilder.DALRuntimeContext)context)));
        }

        public static interface DataDataObject
        extends BiFunction<Data, Data, Object> {
        }

        public static interface DataObject
        extends Function<Object, Object> {
        }

        public static interface DataContextData
        extends BiFunction<Data, RuntimeContextBuilder.DALRuntimeContext, Data> {
        }

        public static interface DataOptDataContextData
        extends QuadFunction<Data, DALOperator, Data, RuntimeContextBuilder.DALRuntimeContext, Data> {
        }

        public static interface SupplierSupplierData
        extends BiFunction<Supplier<Data>, Supplier<Data>, Data> {
        }
    }
}

