/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.ast.opt.Factory;
import com.github.leeonky.dal.compiler.Constants;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Calculator;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.OperatorParser;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.util.function.Extension;
import java.util.Optional;

public class Operators {
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> DEFAULT_OPERATOR = Procedure::currentOperator;
    private static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> MAYBE_PROPERTY_SLASH = Notations.Operators.SLASH.operator(() -> Factory.executable(Notations.Operators.SLASH));
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> IS = Notations.Operators.IS.keywordOperator(Factory::is, Constants.PROPERTY_DELIMITER_STRING);
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> WHICH = Notations.Operators.WHICH.operator(Factory::which);
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> PROPERTY_DOT = Notations.Operators.DOT.operator(() -> Factory.executable(Notations.Operators.DOT), Extension.not(DALProcedure::mayBeElementEllipsis));
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> PROPERTY_SLASH = procedure -> procedure.isEnableSlashProperty() ? MAYBE_PROPERTY_SLASH.parse(procedure) : Optional.empty();
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> PROPERTY_IMPLICIT = procedure -> Optional.of(Factory.executable(Notations.EMPTY));
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> PROPERTY_META = Notations.Operators.META.operator(() -> Factory.executable(Notations.Operators.META));
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> BINARY_ARITHMETIC_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.AND.operator(() -> Factory.logical(Notations.Operators.AND, Calculator::and)), Notations.Operators.OR.operator(() -> Factory.logical(Notations.Operators.OR, Calculator::or)), Notations.Keywords.AND.keywordOperator(() -> Factory.logical(Notations.Keywords.AND, Calculator::and), Constants.PROPERTY_DELIMITER_STRING), Notations.COMMA.operator(() -> Factory.logical(Notations.COMMA, Calculator::and), DALProcedure::isEnableCommaAnd), Notations.Operators.NOT_EQUAL.operator(() -> Factory.comparator(Notations.Operators.NOT_EQUAL, Factory.ExpressionContextData.adapt(Calculator::notEqual))), Notations.Keywords.OR.keywordOperator(() -> Factory.logical(Notations.Keywords.OR, Calculator::or), Constants.PROPERTY_DELIMITER_STRING), Notations.Operators.GREATER_OR_EQUAL.operator(() -> Factory.comparator(Notations.Operators.GREATER_OR_EQUAL, Factory.ExpressionContextData.adapt(Calculator::greaterOrEqual))), Notations.Operators.LESS_OR_EQUAL.operator(() -> Factory.comparator(Notations.Operators.LESS_OR_EQUAL, Factory.ExpressionContextData.adapt(Calculator::lessOrEqual))), Notations.Operators.GREATER.operator(() -> Factory.comparator(Notations.Operators.GREATER, Factory.ExpressionContextData.adapt(Calculator::greater))), Notations.Operators.LESS.operator(() -> Factory.comparator(Notations.Operators.LESS, Factory.ExpressionContextData.adapt(Calculator::less)), Extension.not(DALProcedure::mayBeOpeningGroup)), Notations.Operators.PLUS.operator(() -> Factory.plusSub(Notations.Operators.PLUS, Calculator::plus, com.github.leeonky.dal.runtime.Operators.PLUS)), Notations.Operators.SUBTRACTION.operator(() -> Factory.plusSub(Notations.Operators.SUBTRACTION, Calculator::subtract, com.github.leeonky.dal.runtime.Operators.SUB)), Notations.Operators.MULTIPLICATION.operator(() -> Factory.mulDiv(Notations.Operators.MULTIPLICATION, Calculator::multiply, com.github.leeonky.dal.runtime.Operators.MUL)), Notations.Operators.DIVISION.operator(() -> Factory.mulDiv(Notations.Operators.DIVISION, Calculator::divide, com.github.leeonky.dal.runtime.Operators.DIV))});
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> UNARY_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.MINUS.operator(() -> Factory.unary(Notations.Operators.MINUS, Factory.ExpressionContextData.adapt(Calculator::negate)), Extension.not(DALProcedure::isCodeBeginning)), Notations.Operators.PLUS.operator(() -> Factory.unary(Notations.Operators.PLUS, Factory.ExpressionContextData.adapt(Calculator::positive)), Extension.not(DALProcedure::isCodeBeginning)), Notations.Operators.NOT.operator(() -> Factory.unary(Notations.Operators.NOT, Factory.ExpressionContextData.adapt(Calculator::not)), Extension.not(DALProcedure::mayBeUnEqual))});
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> VERIFICATION_OPERATORS = (OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Notations.Operators.MATCHER.operator(Factory::match, Extension.not(DALProcedure::mayBeMetaProperty)), Notations.Operators.EQUAL.operator(Factory::equal)});
    static final OperatorParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> DATA_REMARK = Notations.Operators.DATA_REMARK.operator(Factory::dataRemark);
    static final OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALOperator, DALProcedure, DALExpression> DEFAULT_VERIFICATION_OPERATOR = (OperatorParser.Mandatory)DEFAULT_OPERATOR.mandatory("");
}

