/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.Operation;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.NumberType;
import com.github.leeonky.util.function.TriFunction;

public class Operators
implements Extension {
    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void extend(DAL dal) {
        this.numberCalculator(dal, com.github.leeonky.dal.runtime.Operators.PLUS, (TriFunction<NumberType, Number, Number, Number>)((TriFunction)NumberType::plus));
        this.stringPlus(dal);
        this.numberCalculator(dal, com.github.leeonky.dal.runtime.Operators.SUB, (TriFunction<NumberType, Number, Number, Number>)((TriFunction)NumberType::subtract));
        this.numberCalculator(dal, com.github.leeonky.dal.runtime.Operators.MUL, (TriFunction<NumberType, Number, Number, Number>)((TriFunction)NumberType::multiply));
        this.numberCalculator(dal, com.github.leeonky.dal.runtime.Operators.DIV, (TriFunction<NumberType, Number, Number, Number>)((TriFunction)NumberType::divide));
        this.assertEqual(dal);
        this.assertMatch(dal);
    }

    private void assertMatch(DAL dal) {
        dal.getRuntimeContextBuilder().registerOperator(com.github.leeonky.dal.runtime.Operators.MATCH, new Operation(){

            @Override
            public boolean match(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return v2.instance() instanceof ExpectationFactory;
            }

            @Override
            public Data operate(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                ((ExpectationFactory)v2.instance()).create(operator, v1).matches();
                return v1;
            }
        });
    }

    private void assertEqual(DAL dal) {
        dal.getRuntimeContextBuilder().registerOperator(com.github.leeonky.dal.runtime.Operators.EQUAL, new Operation(){

            @Override
            public boolean match(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return v2.instance() instanceof ExpectationFactory;
            }

            @Override
            public Data operate(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                ((ExpectationFactory)v2.instance()).create(operator, v1).equalTo();
                return v1;
            }
        });
    }

    private void stringPlus(DAL dal) {
        dal.getRuntimeContextBuilder().registerOperator(com.github.leeonky.dal.runtime.Operators.PLUS, new Operation(){

            @Override
            public boolean match(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return v1.instance() instanceof String || v2.instance() instanceof String;
            }

            @Override
            public Data operate(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.wrap(String.valueOf(v1.instance()) + v2.instance());
            }
        });
    }

    private void numberCalculator(DAL dal, com.github.leeonky.dal.runtime.Operators operator, final TriFunction<NumberType, Number, Number, Number> action) {
        dal.getRuntimeContextBuilder().registerOperator(operator, new Operation(){

            @Override
            public boolean match(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return v1.instance() instanceof Number && v2.instance() instanceof Number;
            }

            @Override
            public Data operate(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.wrap(action.apply((Object)context.getNumberType(), (Object)((Number)v1.instance()), (Object)((Number)v2.instance())));
            }
        });
    }
}

