/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.InfiniteCollectionException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.Classes;
import com.github.leeonky.util.NumberType;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class Calculator {
    private static final NumberType numberType = new NumberType();

    private static int compare(Data v1, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        Object instance1 = v1.instance();
        Object instance2 = v2.instance();
        if (instance1 == null || instance2 == null) {
            throw ExpressionException.illegalOperationRuntimeException(String.format("Can not compare [%s] and [%s]", instance1, instance2));
        }
        if (instance1 instanceof Number && instance2 instanceof Number) {
            return context.getNumberType().compare((Number)instance1, (Number)instance2);
        }
        if (instance1 instanceof String && instance2 instanceof String) {
            return ((String)instance1).compareTo((String)instance2);
        }
        throw ExpressionException.illegalOperationRuntimeException(String.format("Can not compare [%s: %s] and [%s: %s]", Classes.getClassName((Object)instance1), instance1, Classes.getClassName((Object)instance2), instance2));
    }

    public static boolean equals(Data v1, Data v2) {
        if (v1.instance() == v2.instance()) {
            return true;
        }
        if (ExpressionException.opt2(v2::isNull).booleanValue()) {
            return ExpressionException.opt1(v1::isNull);
        }
        if (v2.isList() && v1.isList()) {
            return Calculator.collect(v2, "2").equals(Calculator.collect(v1, "1"));
        }
        return Objects.equals(v1.instance(), v2.instance());
    }

    private static List<Object> collect(Data v2, String index) {
        try {
            return v2.list().collect();
        }
        catch (InfiniteCollectionException ignore) {
            throw ExpressionException.illegalOperationRuntimeException("Invalid operation, operand " + index + " is infinite collection");
        }
    }

    public static Data plus(Data v1, DALOperator opt, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.calculate(v1, opt, v2);
    }

    public static Data subtract(Data v1, DALOperator opt, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.calculate(v1, opt, v2);
    }

    public static Data multiply(Data v1, DALOperator opt, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.calculate(v1, opt, v2);
    }

    public static Data divide(Data v1, DALOperator opt, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.calculate(v1, opt, v2);
    }

    public static Data and(Supplier<Data> s1, Supplier<Data> s2) {
        Data v1 = s1.get();
        return Calculator.isTrue(v1) ? s2.get() : v1;
    }

    private static boolean isTrue(Data value) {
        if (value.instance() instanceof Boolean) {
            return (Boolean)value.instance();
        }
        if (value.instance() instanceof Number) {
            return numberType.compare((Number)0, (Number)value.instance()) != 0;
        }
        return !value.isNull();
    }

    public static Data or(Supplier<Data> s1, Supplier<Data> s2) {
        Data v1 = s1.get();
        return Calculator.isTrue(v1) ? v1 : s2.get();
    }

    public static Object not(Object v) {
        if (!(v instanceof Boolean)) {
            throw ExpressionException.illegalOperationRuntimeException("Operand should be boolean but '" + Classes.getClassName((Object)v) + "'");
        }
        return (Boolean)v == false;
    }

    public static Data negate(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        Object value = data.instance();
        if (value instanceof Number) {
            return context.wrap(context.getNumberType().negate((Number)value));
        }
        if (data.isList()) {
            return Calculator.sortList(data, Comparator.reverseOrder());
        }
        throw ExpressionException.illegalOperationRuntimeException(String.format("Operand should be number or list but '%s'", Classes.getClassName((Object)value)));
    }

    private static Data sortList(Data data, Comparator<?> comparator) {
        try {
            return data.list().sort(Comparator.comparing(Data::instance, comparator)).wrap();
        }
        catch (InfiniteCollectionException e) {
            throw ExpressionException.illegalOperationRuntimeException("Can not sort infinite collection");
        }
    }

    public static Data positive(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        Object value = data.instance();
        if (data.isList()) {
            return Calculator.sortList(data, Comparator.naturalOrder());
        }
        throw ExpressionException.illegalOp2RuntimeException(String.format("Operand should be list but '%s'", Classes.getClassName((Object)value)));
    }

    public static Data less(Data left, DALOperator opt, Data right, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(Calculator.compare(left, right, context) < 0);
    }

    public static Data greaterOrEqual(Data left, DALOperator opt, Data right, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(Calculator.compare(left, right, context) >= 0);
    }

    public static Data lessOrEqual(Data left, DALOperator opt, Data right, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(Calculator.compare(left, right, context) <= 0);
    }

    public static Data greater(Data left, DALOperator opt, Data right, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(Calculator.compare(left, right, context) > 0);
    }

    public static boolean notEqual(Data left, Data right) {
        return !Calculator.equals(left, right);
    }
}

