/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.IndexedElement;
import com.github.leeonky.dal.runtime.IterableDALCollection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface DALCollection<E>
extends Iterable<IndexedElement<E>> {
    public int size();

    public E getByIndex(int var1);

    public int firstIndex();

    public DALCollection<E> requireLimitedCollection(String var1);

    public List<E> collect();

    default public DALCollection<E> filter(Predicate<E> predicate) {
        return new IterableDALCollection<E>(() -> Spliterators.iterator(this.values().filter(predicate).spliterator())){

            @Override
            public int firstIndex() {
                return DALCollection.this.firstIndex();
            }
        };
    }

    public Stream<E> values();

    public Stream<Integer> indexes();

    public <R> DALCollection<R> map(IndexedElement.Mapper<? super E, ? extends R> var1);

    public Stream<IndexedElement<E>> stream();

    public boolean infinite();

    public DALCollection<Object> limit(int var1);

    public static class Decorated<E>
    implements DALCollection<E> {
        private final DALCollection<E> origin;

        public Decorated(DALCollection<E> origin) {
            this.origin = origin;
        }

        @Override
        public int size() {
            return this.origin.size();
        }

        @Override
        public E getByIndex(int index) {
            return this.origin.getByIndex(index);
        }

        @Override
        public Iterator<IndexedElement<E>> iterator() {
            return this.origin.iterator();
        }

        @Override
        public int firstIndex() {
            return this.origin.firstIndex();
        }

        @Override
        public List<E> collect() {
            return this.origin.collect();
        }

        @Override
        public DALCollection<E> filter(Predicate<E> predicate) {
            return this.origin.filter(predicate);
        }

        @Override
        public boolean infinite() {
            return this.origin.infinite();
        }

        @Override
        public DALCollection<Object> limit(int size) {
            return this.origin.limit(size);
        }

        @Override
        public Stream<E> values() {
            return this.origin.values();
        }

        @Override
        public Stream<Integer> indexes() {
            return this.origin.indexes();
        }

        @Override
        public <R> DALCollection<R> map(IndexedElement.Mapper<? super E, ? extends R> mapper) {
            return this.origin.map(mapper);
        }

        @Override
        public Stream<IndexedElement<E>> stream() {
            return this.origin.stream();
        }

        @Override
        public Decorated<E> requireLimitedCollection(String message) {
            this.origin.requireLimitedCollection(message);
            return this;
        }
    }
}

