/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.util.ConvertException;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.NumberType;
import java.lang.reflect.Parameter;

class ParameterValue {
    private final Parameter parameter;
    private final Object value;

    public ParameterValue(Parameter parameter, Object value) {
        this.parameter = parameter;
        this.value = value;
    }

    public boolean isSameType() {
        return this.value != null && NumberType.boxedClass(this.value.getClass()).equals(NumberType.boxedClass(this.parameter.getType()));
    }

    public boolean isSuperType() {
        return this.value != null && NumberType.boxedClass(this.parameter.getType()).isInstance(this.value);
    }

    boolean isConvertibleType(Converter converter) {
        try {
            converter.convert(this.parameter.getType(), this.value);
            return true;
        }
        catch (ConvertException ignore) {
            return false;
        }
    }

    Object getArg(Converter converter) {
        return converter.convert(this.parameter.getType(), this.value);
    }
}

