/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.ExtendedFactory;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import com.github.leeonky.javabuilder.NoFactoryException;
import com.github.leeonky.util.BeanClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class AbstractFactory<T>
implements Factory<T> {
    protected final FactorySet factorySet;
    private final BeanClass<T> beanClass;
    private Map<String, Factory> subFactories = new HashMap<String, Factory>();
    private Map<String, BiConsumer<T, BuildContext<T>>> combinations = new HashMap<String, BiConsumer<T, BuildContext<T>>>();

    public AbstractFactory(FactorySet factorySet, Class<T> type) {
        this.factorySet = factorySet;
        this.beanClass = BeanClass.create(type);
    }

    @Override
    public int getSequence() {
        return this.factorySet.getTypeSequence(this.beanClass.getType());
    }

    @Override
    public Factory<T> extend(String name, BiConsumer<T, BuildContext<T>> consumer) {
        try {
            this.getRoot().query(name);
            throw new IllegalArgumentException("Duplicated factory name[" + name + "] for " + this.beanClass.getName());
        }
        catch (NoFactoryException ignore) {
            ExtendedFactory<T> extendedFactory = new ExtendedFactory<T>(this.factorySet, this, name, consumer);
            this.subFactories.put(name, extendedFactory);
            return extendedFactory;
        }
    }

    @Override
    public Factory<T> query(String extend) {
        ArrayList<Factory<T>> result = new ArrayList<Factory<T>>();
        this.queryAll(extend, result);
        if (result.size() == 0) {
            throw new NoFactoryException(extend, this.beanClass.getType());
        }
        return (Factory)result.get(0);
    }

    private void queryAll(String extend, List<Factory<T>> result) {
        Factory factory = this.subFactories.get(extend);
        if (factory != null) {
            result.add(factory);
        }
        this.subFactories.values().forEach(f -> ((AbstractFactory)f).queryAll(extend, result));
    }

    @Override
    public BeanClass<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Factory<T> registerAlias() {
        return this.registerAlias(this.getBeanClass().getSimpleName());
    }

    @Override
    public Factory<T> registerAlias(String alias) {
        this.factorySet.aliasFactory(alias, this);
        return this;
    }

    @Override
    public Factory<T> canCombine(String name, BiConsumer<T, BuildContext<T>> combination) {
        if (this.combinations.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Combination [%s] exists", name));
        }
        this.combinations.put(name, combination);
        return this;
    }

    @Override
    public void combineBuild(T object, String name, BuildContext<T> buildContext) {
        this.combinations.getOrDefault(name, (o, b) -> {
            throw new IllegalArgumentException(String.format("Combination [%s] does not exist", name));
        }).accept(object, buildContext);
    }
}

