/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.AbstractFactory;
import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.FactorySet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;

class BeanFactory<T>
extends AbstractFactory<T> {
    private final BiConsumer<T, BuildContext<T>> consumer;
    private final Constructor<T> constructor;

    BeanFactory(FactorySet factorySet, Class<T> type, BiConsumer<T, BuildContext<T>> consumer) {
        super(factorySet, type);
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No default constructor of class: " + type.getName(), e);
        }
        this.consumer = consumer;
    }

    @Override
    public T createObject(BuildContext<T> buildContext) {
        T instance;
        try {
            instance = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        this.consumer.accept(instance, buildContext);
        return instance;
    }
}

