/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.PropertyWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class DefaultBuilder<T>
implements Builder<T> {
    private final Factory<T> factory;
    private final FactorySet factorySet;
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<String> combinations = new ArrayList<String>();

    DefaultBuilder(FactorySet factorySet, Factory<T> factory) {
        this.factory = Objects.requireNonNull(factory);
        this.factorySet = factorySet;
    }

    private DefaultBuilder<T> copy() {
        DefaultBuilder<T> newBuilder = new DefaultBuilder<T>(this.factorySet, this.factory);
        newBuilder.params.putAll(this.params);
        newBuilder.properties.putAll(this.properties);
        newBuilder.combinations.addAll(this.combinations);
        return newBuilder;
    }

    @Override
    public Builder<T> params(Map<String, ?> params) {
        DefaultBuilder<T> builder = this.copy();
        builder.params.putAll(params);
        return builder;
    }

    @Override
    public Builder<T> properties(Map<String, ?> properties) {
        DefaultBuilder<T> builder = this.copy();
        builder.properties.putAll(properties);
        return builder;
    }

    @Override
    public Builder<T> property(String name, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(name, value);
        return this.properties(map);
    }

    @Override
    public Builder<T> combine(String name) {
        DefaultBuilder<T> builder = this.copy();
        builder.combinations.add(name);
        return builder;
    }

    @Override
    public T build() {
        return this.factorySet.getDataRepository().save(this.buildWithoutSave());
    }

    @Override
    public T buildWithoutSave() {
        HashMap<String, Object> processed = new HashMap<String, Object>();
        this.properties.forEach((k, v) -> this.processProperties(this.factory.getBeanClass(), (Map<String, Object>)processed, (String)k, v));
        BuildContext<T> buildContext = new BuildContext<T>(this.factory.getSequence(), processed, this.params, this.factory.getBeanClass(), this.factorySet);
        T object = this.factory.createObject(buildContext);
        this.combinations.forEach(combination -> this.factory.combineBuild(object, (String)combination, (BuildContext<Object>)buildContext));
        processed.forEach((k, v) -> this.factory.getBeanClass().setPropertyValue(object, k, v));
        return object;
    }

    private void processProperties(BeanClass<T> beanClass, Map<String, Object> processed, String name, Object value) {
        if (name.contains(".")) {
            String[] propertyList = name.split("\\.", 2);
            String propertyName = propertyList[0];
            String condition = propertyList[1];
            String factoryName = null;
            if (propertyName.contains("(")) {
                String[] propertyFactory = propertyName.split("\\(");
                propertyName = propertyFactory[0];
                factoryName = propertyFactory[1].split("\\)")[0];
            }
            PropertyWriter propertyWriter = beanClass.getPropertyWriter(propertyName);
            Builder builder = (this.factorySet.hasAlias(factoryName) ? this.factorySet.toBuild(factoryName) : this.factorySet.type(propertyWriter.getPropertyType(), factoryName)).property(condition, value);
            processed.put(propertyWriter.getName(), builder.query().orElseGet(builder::build));
        } else {
            processed.put(name, value);
        }
    }

    @Override
    public Optional<T> query() {
        return this.factorySet.getDataRepository().query(this.factory.getBeanClass(), this.properties);
    }
}

