/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.AbstractFactory;
import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactoryDefinition;
import com.github.leeonky.javabuilder.FactorySet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

class DefinitionFactory<T>
extends AbstractFactory<T> {
    private final FactoryDefinition<T> factoryDefinition;
    private final BiConsumer<T, BuildContext<T>> consumer = factoryDefinition::onBuild;

    DefinitionFactory(FactorySet factorySet, FactoryDefinition<T> factoryDefinition) {
        super(factorySet, factoryDefinition.getType());
        this.factoryDefinition = factoryDefinition;
        Stream.of(factoryDefinition.getClass().getMethods()).filter(m -> this.isCombination(factoryDefinition, (Method)m)).forEach(m -> this.canCombine(m.getName(), (T o, BuildContext<T> b) -> {
            try {
                m.invoke((Object)factoryDefinition, o, b);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }));
    }

    private boolean isCombination(FactoryDefinition<T> factoryDefinition, Method m) {
        return m.getParameters().length == 2 && m.getParameterTypes()[0].isAssignableFrom(factoryDefinition.getType()) && m.getParameterTypes()[1] == BuildContext.class && !m.getName().equals("onBuild");
    }

    @Override
    public T createObject(BuildContext<T> buildContext) {
        T instance = this.factorySet.factory(this.factoryDefinition.getType()).createObject(buildContext);
        this.consumer.accept(instance, buildContext);
        return instance;
    }

    @Override
    public Factory<T> registerAlias() {
        return this.registerAlias(this.factoryDefinition.getAlias());
    }
}

