/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanAssigner;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.FactorySet;
import com.github.leeonky.javabuilder.PropertyBuilder;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.PropertyWriter;
import java.util.Map;
import java.util.function.Supplier;

public class BuildContext<T> {
    private final Map<String, Object> params;
    private final Map<String, Object> properties;
    private final int sequence;
    private final PropertyBuilder propertyBuilder;
    private final BeanClass<T> beanClass;
    private final FactorySet factorySet;

    public BuildContext(int sequence, Map<String, Object> properties, Map<String, Object> params, BeanClass<T> beanClass, FactorySet factorySet) {
        this.params = params;
        this.properties = properties;
        this.sequence = sequence;
        this.propertyBuilder = factorySet.getPropertyBuilder();
        this.beanClass = beanClass;
        this.factorySet = factorySet;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public int getSequence() {
        return this.sequence;
    }

    public BeanClass<T> getBeanClass() {
        return this.beanClass;
    }

    public BeanAssigner<T> assignTo(T object) {
        return new DefaultBeanAssigner(object);
    }

    public boolean notSpecified(String name) {
        return !this.properties.containsKey(name);
    }

    class DefaultBeanAssigner
    implements BeanAssigner<T> {
        private final T object;

        DefaultBeanAssigner(T object) {
            this.object = object;
        }

        @Override
        public BeanAssigner<T> setDefault() {
            BuildContext.this.propertyBuilder.buildDefaultProperty(this.object, BuildContext.this);
            return this;
        }

        @Override
        public BeanAssigner<T> setPropertyDefaultInFactory(String property, String factory) {
            if (BuildContext.this.notSpecified(property)) {
                PropertyWriter propertyWriter = BuildContext.this.beanClass.getPropertyWriter(property);
                Builder builder = BuildContext.this.factorySet.hasAlias(factory) ? BuildContext.this.factorySet.toBuild(factory) : BuildContext.this.factorySet.type(propertyWriter.getPropertyType(), factory);
                propertyWriter.setValue(this.object, builder.build());
            }
            return this;
        }

        @Override
        public BeanAssigner<T> setPropertyDefaultInDefaultFactory(String property) {
            return this.setPropertyDefaultInFactory(property, null);
        }

        @Override
        public BeanAssigner<T> setPropertyDefaultInSupplier(String property, Supplier<?> supplier) {
            if (BuildContext.this.notSpecified(property)) {
                BuildContext.this.beanClass.setPropertyValue(this.object, property, supplier.get());
            }
            return this;
        }
    }
}

