/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.AbstractFactory;
import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import java.util.function.BiConsumer;

class ExtendedFactory<T>
extends AbstractFactory<T> {
    private final Factory<T> parent;
    private final BiConsumer<T, BuildContext<T>> consumer;
    private final String name;

    ExtendedFactory(FactorySet factorySet, Factory<T> parent, String name, BiConsumer<T, BuildContext<T>> consumer) {
        super(factorySet, parent.getBeanClass().getType());
        this.parent = parent;
        this.consumer = consumer;
        this.name = name;
    }

    @Override
    public int getSequence() {
        return this.parent.getSequence();
    }

    @Override
    public T createObject(BuildContext<T> buildContext) {
        T object = this.parent.createObject(buildContext);
        this.consumer.accept(object, buildContext);
        return object;
    }

    @Override
    public Factory<T> getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public Factory<T> registerAlias() {
        return this.registerAlias(this.name);
    }
}

