/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky;

import com.github.leeonky.Builder;
import com.github.leeonky.DefaultBuilder;
import com.github.leeonky.DefaultFactory;
import com.github.leeonky.Factory;
import com.github.leeonky.TriConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class FactorySet {
    private Map<Class, Factory> factories = new HashMap<Class, Factory>();

    public <T> Builder<T> type(Class<T> type) {
        return new DefaultBuilder(this.factories.get(type));
    }

    public <T> void register(Class<T> type, Consumer<T> consumer) {
        this.register(type, (T obj, Integer seq) -> consumer.accept(obj));
    }

    public <T> void register(Class<T> type, BiConsumer<T, Integer> consumer) {
        this.register(type, (T obj, Integer seq, Map<String, Object> params) -> consumer.accept((Object)obj, (Integer)seq));
    }

    public <T> void register(Class<T> type, TriConsumer<T, Integer, Map<String, Object>> consumer) {
        DefaultFactory<T> defaultFactory;
        try {
            defaultFactory = new DefaultFactory<T>(consumer, type.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No default constructor of class: " + type.getName(), e);
        }
        this.factories.put(type, defaultFactory);
    }
}

