/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.AbstractFactory;
import com.github.leeonky.javabuilder.TriConsumer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

class BeanFactory<T>
extends AbstractFactory<T> {
    private final TriConsumer<T, Integer, Map<String, Object>> consumer;
    private final Constructor<T> constructor;

    BeanFactory(Class<T> type, TriConsumer<T, Integer, Map<String, Object>> consumer) {
        super(type);
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No default constructor of class: " + type.getName(), e);
        }
        this.consumer = consumer;
    }

    @Override
    public T createObject(int sequence, Map<String, Object> params) {
        T instance;
        try {
            instance = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        this.consumer.accept(instance, sequence, params);
        return instance;
    }
}

