/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.TypeOperator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class Converter {
    private Map<Class<?>, List<TypeOperator<Function>>> typeConverters = new HashMap();
    private Map<Class<?>, List<TypeOperator<BiFunction>>> enumConverters = new HashMap();

    public static Class<?> boxedClass(Class<?> source) {
        if (source.isPrimitive()) {
            if (source == Integer.TYPE) {
                return Integer.class;
            }
            if (source == Short.TYPE) {
                return Short.class;
            }
            if (source == Long.TYPE) {
                return Long.class;
            }
            if (source == Float.TYPE) {
                return Float.class;
            }
            if (source == Double.TYPE) {
                return Double.class;
            }
            if (source == Boolean.TYPE) {
                return Boolean.class;
            }
        }
        return source;
    }

    public static Converter createDefaultConverter() {
        return new Converter().addTypeConverter(Object.class, String.class, Object::toString).addTypeConverter(String.class, Long.TYPE, Long::valueOf).addTypeConverter(String.class, Integer.TYPE, Integer::valueOf).addTypeConverter(String.class, Short.TYPE, Short::valueOf).addTypeConverter(String.class, Byte.TYPE, Byte::valueOf).addTypeConverter(String.class, Double.TYPE, Double::valueOf).addTypeConverter(String.class, Float.TYPE, Float::valueOf).addTypeConverter(String.class, Boolean.TYPE, Boolean::valueOf).addTypeConverter(String.class, Long.class, Long::valueOf).addTypeConverter(String.class, Integer.class, Integer::valueOf).addTypeConverter(String.class, Short.class, Short::valueOf).addTypeConverter(String.class, Byte.class, Byte::valueOf).addTypeConverter(String.class, Double.class, Double::valueOf).addTypeConverter(String.class, Float.class, Float::valueOf).addTypeConverter(String.class, Boolean.class, Boolean::valueOf).addTypeConverter(String.class, BigInteger.class, BigInteger::new).addTypeConverter(String.class, BigDecimal.class, BigDecimal::new).addTypeConverter(String.class, UUID.class, UUID::fromString).addTypeConverter(String.class, Instant.class, Instant::parse).addTypeConverter(String.class, Date.class, source -> {
            try {
                return new SimpleDateFormat("yyyy-MM-dd").parse((String)source);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot convert '" + source + "' to " + Date.class.getName(), e);
            }
        }).addTypeConverter(String.class, LocalTime.class, LocalTime::parse).addTypeConverter(String.class, LocalDate.class, LocalDate::parse).addTypeConverter(String.class, LocalDateTime.class, LocalDateTime::parse).addTypeConverter(Long.class, BigDecimal.class, BigDecimal::new).addTypeConverter(Integer.class, BigDecimal.class, BigDecimal::new).addTypeConverter(Short.class, BigDecimal.class, BigDecimal::new).addTypeConverter(Byte.class, BigDecimal.class, BigDecimal::new).addTypeConverter(Float.class, BigDecimal.class, BigDecimal::new).addTypeConverter(Double.class, BigDecimal.class, BigDecimal::new);
    }

    public <T, R> Converter addTypeConverter(Class<T> source, Class<R> target, Function<T, R> converter) {
        this.typeConverters.computeIfAbsent(target, k -> new ArrayList()).add(new TypeOperator<Function<T, R>>(Converter.boxedClass(source), converter));
        return this;
    }

    private <T> Optional<TypeOperator<T>> findTypeConverter(Class<?> source, Class<?> target, Map<Class<?>, List<TypeOperator<T>>> typeConverters, List<TypeOperator<T>> defaultValue) {
        List<TypeOperator<T>> converters = typeConverters.getOrDefault(target, defaultValue);
        return Stream.concat(converters.stream().filter(t -> t.isPreciseType(source)), converters.stream().filter(t -> t.isBaseType(source))).findFirst();
    }

    public Object tryConvert(Class<?> type, Object value) {
        Class<?> sourceType = value.getClass();
        return type.isAssignableFrom(sourceType) ? value : this.findTypeConverter(sourceType, type, this.typeConverters, Collections.emptyList()).map(c -> ((Function)c.getConverter()).apply(value)).orElseGet(() -> type.isEnum() ? this.findTypeConverter(sourceType, type, this.enumConverters, this.getBaseEnumTypeConverts(type, this.enumConverters)).map(c -> ((BiFunction)c.getConverter()).apply(type, value)).orElseGet(() -> Enum.valueOf(type, value.toString())) : value);
    }

    private List<TypeOperator<BiFunction>> getBaseEnumTypeConverts(Class<?> type, Map<Class<?>, List<TypeOperator<BiFunction>>> enumConverters) {
        return enumConverters.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(Map.Entry::getValue).findFirst().orElse(Collections.emptyList());
    }

    public <E, V> Converter addEnumConverter(Class<V> source, Class<E> target, BiFunction<Class<E>, V, E> converter) {
        this.enumConverters.computeIfAbsent(target, k -> new ArrayList()).add(new TypeOperator<BiFunction<Class<E>, V, E>>(Converter.boxedClass(source), converter));
        return this;
    }
}

