/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanUtil;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.Converter;
import com.github.leeonky.javabuilder.Factory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

class DefaultBuilder<T>
implements Builder<T> {
    private final Factory<T> factory;
    private final Consumer<Converter> register;
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private BeanUtil beanUtil = new BeanUtil();

    public DefaultBuilder(Factory<T> factory, Consumer<Converter> register) {
        this.factory = Objects.requireNonNull(factory);
        this.register = register;
        register.accept(this.beanUtil.getConverter());
    }

    private DefaultBuilder<T> copy() {
        DefaultBuilder<T> newBuilder = new DefaultBuilder<T>(this.factory, this.register);
        newBuilder.params.putAll(this.params);
        return newBuilder;
    }

    @Override
    public Builder<T> params(Map<String, ?> params) {
        DefaultBuilder<T> builder = this.copy();
        builder.params.putAll(params);
        return builder;
    }

    @Override
    public Builder<T> properties(Map<String, ?> properties) {
        DefaultBuilder<T> builder = this.copy();
        builder.properties.putAll(properties);
        return builder;
    }

    @Override
    public T build() {
        return this.beanUtil.assignProperties(this.factory.createObject(this.factory.getSequence(), this.params), this.properties);
    }
}

